/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.multibreak;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.vermulst.multibreak.Main;
import me.vermulst.multibreak.config.ConfigManager;
import me.vermulst.multibreak.figure.Figure;
import me.vermulst.multibreak.item.FigureItemDataType;
import me.vermulst.multibreak.multibreak.MultiBreak;
import me.vermulst.multibreak.multibreak.event.MultiBreakEndEvent;
import me.vermulst.multibreak.multibreak.event.MultiBreakStartEvent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerAnimationType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BreakManager
implements Listener {
    private final Main plugin;
    private final Map<UUID, Integer> multiBreakTask = new HashMap<UUID, Integer>();
    private final Map<UUID, MultiBreak> multiBlockHashMap = new HashMap<UUID, MultiBreak>();

    public BreakManager(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void armSwingEvent(PlayerAnimationEvent e) {
        boolean legacy_mode = this.plugin.getConfigManager().getOptions()[1];
        if (!legacy_mode) {
            return;
        }
        if (!e.getAnimationType().equals((Object)PlayerAnimationType.ARM_SWING)) {
            return;
        }
        Player p = e.getPlayer();
        if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        MultiBreak multiBreak = this.getMultiBreak(p);
        if (multiBreak == null) {
            return;
        }
        Block blockMining = this.getTargetBlock(p);
        if (blockMining == null) {
            return;
        }
        multiBreak.tick(this.getPlugin(), blockMining);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void multiBreakStart(BlockDamageEvent e) {
        boolean legacy_mode = this.plugin.getConfigManager().getOptions()[1];
        if (legacy_mode) {
            return;
        }
        this.scheduleMultiBreak(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void multiBreakStop(BlockDamageAbortEvent e) {
        boolean legacy_mode = this.plugin.getConfigManager().getOptions()[1];
        if (legacy_mode) {
            return;
        }
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getMultiBreak(p);
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, false);
        event.callEvent();
        if (multiBreak == null) {
            return;
        }
        this.end(p, multiBreak, false);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void breakBlockType(BlockBreakEvent e) {
        if (this.ignoreMultiBreak(e)) {
            return;
        }
        Player p = e.getPlayer();
        MultiBreak multiBreak = this.getMultiBreak(p);
        MultiBreakEndEvent event = new MultiBreakEndEvent(p, multiBreak, true);
        event.callEvent();
        if (event.isCancelled()) {
            return;
        }
        if (event.getMultiBreak() == null) {
            return;
        }
        this.end(p, event.getMultiBreak(), true);
    }

    private boolean ignoreMultiBreak(BlockBreakEvent e) {
        Block block = e.getBlock();
        boolean b1 = block.hasMetadata("multi-broken");
        boolean b2 = this.plugin.getConfigManager().getIgnoredMaterials().contains(block.getType());
        boolean b3 = e.isCancelled();
        if (block.hasMetadata("multi-broken")) {
            block.removeMetadata("multi-broken", (Plugin)this.getPlugin());
        }
        return b1 || b2 || b3;
    }

    public void scheduleMultiBreak(Player p) {
        final MultiBreak multiBreak = this.getMultiBreak(p);
        if (multiBreak == null) {
            return;
        }
        int taskID = new BukkitRunnable(){

            public void run() {
                multiBreak.tick();
            }
        }.runTaskTimer((Plugin)this.getPlugin(), 0L, 1L).getTaskId();
        this.getMultiBreakTask().put(p.getUniqueId(), taskID);
    }

    public void end(Player p, MultiBreak multiBreak, boolean finished) {
        UUID uuid = p.getUniqueId();
        multiBreak.end(finished, this.getPlugin());
        this.getMultiBlockHashMap().remove(uuid);
        if (!this.getMultiBreakTask().containsKey(uuid)) {
            return;
        }
        Bukkit.getScheduler().cancelTask(this.getMultiBreakTask().get(uuid).intValue());
    }

    public MultiBreak getMultiBreak(Player p) {
        MultiBreak multiBreak;
        if (p.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return null;
        }
        if (this.multiBlockHashMap.containsKey(p.getUniqueId()) && !(multiBreak = this.multiBlockHashMap.get(p.getUniqueId())).hasEnded()) {
            return multiBreak;
        }
        ItemStack tool = p.getInventory().getItemInMainHand();
        Figure figure = this.getFigure(tool);
        BlockFace blockFace = this.getBlockFace(p);
        Block blockMining = this.getTargetBlock(p);
        if (blockMining == null || blockFace == null) {
            return null;
        }
        ConfigManager config = this.plugin.getConfigManager();
        boolean fair_mode = config.getOptions()[0];
        EnumSet<Material> ignoredMaterials = config.getIgnoredMaterials();
        MultiBreak multiBreak2 = new MultiBreak(p, blockMining, figure, blockFace.getDirection(), fair_mode, ignoredMaterials);
        MultiBreakStartEvent event = new MultiBreakStartEvent(p, multiBreak2, blockMining, blockFace.getDirection(), fair_mode, ignoredMaterials);
        if (!event.callEvent()) {
            return null;
        }
        MultiBreak multiBreak1 = event.getMultiBreak();
        this.multiBlockHashMap.put(p.getUniqueId(), multiBreak1);
        return multiBreak1;
    }

    public Figure getFigure(ItemStack tool) {
        if (tool.getItemMeta() == null) {
            return null;
        }
        FigureItemDataType.FigureItemInfo figureItemInfo = this.getFigureItemInfo(tool);
        if (figureItemInfo == null) {
            Material material = tool.getType();
            ConfigManager configManager = this.getPlugin().getConfigManager();
            if (configManager.getMaterialOptions().containsKey(material)) {
                String configOptionName = configManager.getMaterialOptions().get(material);
                return configManager.getConfigOptions().get(configOptionName);
            }
            return null;
        }
        return figureItemInfo.figure();
    }

    public FigureItemDataType.FigureItemInfo getFigureItemInfo(ItemStack item) {
        FigureItemDataType figureItemDataType = new FigureItemDataType((Plugin)this.getPlugin());
        return figureItemDataType.get(item);
    }

    public Block getTargetBlock(Player p) {
        return p.getTargetBlockExact(this.plugin.getConfigManager().getMaxRange());
    }

    public BlockFace getBlockFace(Player p) {
        return p.getTargetBlockFace(this.plugin.getConfigManager().getMaxRange());
    }

    public Main getPlugin() {
        return this.plugin;
    }

    public Map<UUID, Integer> getMultiBreakTask() {
        return this.multiBreakTask;
    }

    public Map<UUID, MultiBreak> getMultiBlockHashMap() {
        return this.multiBlockHashMap;
    }
}

