/*
 * Decompiled with CFR 0.152.
 */
package me.vermulst.multibreak.figure;

import me.vermulst.multibreak.CompassDirection;
import me.vermulst.multibreak.figure.Matrix4x4;
import org.bukkit.util.Vector;

public class VectorTransformer {
    private final Vector playerDirectionVector;
    private final CompassDirection playerDirection;
    private final Matrix4x4 rotationMatrixY;
    private final Matrix4x4 rotationMatrixX;

    public VectorTransformer(Vector playerDirectionVector, CompassDirection playerDirection) {
        this.playerDirectionVector = playerDirectionVector;
        this.playerDirection = playerDirection;
        double angleY = -Math.atan2(playerDirectionVector.getX(), playerDirectionVector.getZ());
        double angleX = -Math.asin(playerDirectionVector.getY());
        Matrix4x4 rotationMatrixY = new Matrix4x4();
        rotationMatrixY.setRotationY(angleY);
        this.rotationMatrixY = rotationMatrixY;
        Matrix4x4 rotationMatrixX = new Matrix4x4();
        rotationMatrixX.setRotationX(angleX);
        this.rotationMatrixX = rotationMatrixX;
    }

    public void rotateVector(Vector vector) {
        this.getRotationMatrixY().transform(vector);
        this.getRotationMatrixX().transform(vector);
        if (Math.abs(this.getPlayerDirectionVector().getY()) == 1.0) {
            vector.rotateAroundY(-this.getPlayerDirection().getAngle());
        } else {
            vector.rotateAroundY(this.getPlayerDirection().getAngle() * 2.0);
        }
    }

    public Vector getPlayerDirectionVector() {
        return this.playerDirectionVector;
    }

    public CompassDirection getPlayerDirection() {
        return this.playerDirection;
    }

    public Matrix4x4 getRotationMatrixY() {
        return this.rotationMatrixY;
    }

    public Matrix4x4 getRotationMatrixX() {
        return this.rotationMatrixX;
    }
}

