/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.armormodel;

import com.google.gson.JsonElement;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorByteBuilder;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorData;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorDataContext;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorDataResult;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorImage;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorImageProcessor;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorNameMapper;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorNamespace;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorResource;
import org.jetbrains.annotations.NotNull;

final class ArmorModelContext
implements AutoCloseable {
    final List<ArmorDataContext> data;
    final ArmorNamespace namespace;
    private final ArmorNameMapper nameMapper;
    private final boolean flush;
    final List<ArmorByteBuilder> builders = new ArrayList<ArmorByteBuilder>();
    private Map<ArmorResource, ArmorDataResult> results;

    ArmorModelContext(@NotNull List<ArmorDataContext> data, @NotNull String namespace, @NotNull ArmorNameMapper nameMapper, boolean flush) {
        this.data = data;
        this.namespace = new ArmorNamespace(this, namespace);
        this.nameMapper = nameMapper;
        this.flush = flush;
    }

    void loadArmor(@NotNull List<ArmorImage> images) {
        for (ArmorImage image : images) {
            ArmorImageProcessor.ARMOR.process(image, this);
        }
    }

    void loadArmorTrim(@NotNull List<ArmorImage> images) {
        for (ArmorImage image : images) {
            ArmorImageProcessor.ARMOR_TRIM.process(image, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<ArmorResource, ArmorDataResult> results() {
        if (this.results != null) {
            return this.results;
        }
        ArmorModelContext armorModelContext = this;
        synchronized (armorModelContext) {
            if (this.results != null) {
                return this.results;
            }
            this.results = Collections.unmodifiableMap(this.data.stream().collect(Collectors.toMap(c -> c.resource, c -> c.build(this.namespace.namespace), (f, s) -> s, () -> new EnumMap(ArmorResource.class))));
            return this.results;
        }
    }

    @NotNull
    String textureName(@NotNull String name) {
        return this.nameMapper.textures().apply(name);
    }

    @NotNull
    String modelName(@NotNull String name) {
        return this.nameMapper.models().apply(name);
    }

    @NotNull
    String textureNamespace(@NotNull String name) {
        return this.namespace.namespace + ":item/armor/" + this.textureName(name);
    }

    @NotNull
    String modelNamespace(@NotNull String name) {
        return this.namespace.namespace + ":armor/" + this.modelName(name);
    }

    @Override
    public void close() {
        if (!this.flush) {
            return;
        }
        for (ArmorDataResult value : this.results().values()) {
            this.namespace.items.add(value.key().item() + ".json", value, v -> ArmorData.GSON.toJson((JsonElement)v.build()).getBytes(StandardCharsets.UTF_8));
        }
    }
}

