/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.collection;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.SequencedSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NonNull;

@Unmodifiable
@ApiStatus.Internal
public final class SingletonSequencedSet<E>
extends AbstractSet<E>
implements SequencedSet<E> {
    private final E element;
    private final Set<E> delegate;

    @NotNull
    public static <E> SingletonSequencedSet<E> of(@NotNull E element) {
        return new SingletonSequencedSet<E>(element);
    }

    private SingletonSequencedSet(@NotNull E element) {
        this.element = element;
        this.delegate = Collections.singleton(element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object o) {
        return this.element.equals(o);
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    @NotNull
    public Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        action.accept(this.element);
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Stream<E> stream() {
        return Stream.of(this.element);
    }

    @Override
    public @NonNull Stream<E> parallelStream() {
        return this.stream();
    }

    @Override
    public E getFirst() {
        return this.element;
    }

    @Override
    public E getLast() {
        return this.element;
    }

    @Override
    public E removeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SequencedSet<E> reversed() {
        return this;
    }
}

