/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class EntityUtil {
    private static final double Y_RENDER_THRESHOLD = Math.toRadians(45.0);
    private static final double IN_POINT_THRESHOLD = Math.toRadians(10.0);
    private static final double X_RENDER_THRESHOLD = Y_RENDER_THRESHOLD * 1.78;

    private EntityUtil() {
        throw new RuntimeException();
    }

    public static double renderDistance() {
        return BetterModel.platform().adapter().serverViewDistance() << 3;
    }

    public static float entityModelViewRadius() {
        return (float)BetterModel.platform().adapter().serverViewDistance() / 4.0f;
    }

    public static boolean canSee(@NotNull PlatformLocation player, @NotNull PlatformLocation target) {
        BetterModelConfig manager = BetterModel.config();
        if (!manager.sightTrace()) {
            return true;
        }
        if (!player.world().equals(target.world())) {
            return false;
        }
        double d = player.distance(target);
        if (d > manager.maxSight()) {
            return false;
        }
        if (d <= manager.minSight()) {
            return true;
        }
        double t = Math.fma(-Math.abs(Math.atan(d)), 2.0, Math.PI);
        double ty = t + Y_RENDER_THRESHOLD;
        double tz = t + X_RENDER_THRESHOLD;
        return EntityUtil.isInDegree(player, target, ty, tz);
    }

    public static boolean isCustomNameVisible(@NotNull PlatformLocation player, @NotNull PlatformLocation target) {
        if (!player.world().equals(target.world())) {
            return false;
        }
        if (player.distanceSquared(target) > 25.0) {
            return false;
        }
        return EntityUtil.isInPoint(player, target);
    }

    public static boolean isInPoint(@NotNull PlatformLocation player, @NotNull PlatformLocation target) {
        return EntityUtil.isInDegree(player, target, IN_POINT_THRESHOLD, IN_POINT_THRESHOLD);
    }

    private static boolean isInDegree(@NotNull PlatformLocation player, @NotNull PlatformLocation target, double ty, double tz) {
        double playerYaw = Math.toRadians(player.yaw());
        double playerPitch = -Math.toRadians(player.pitch());
        double dz = target.z() - player.z();
        double dy = target.y() - player.y();
        double dx = target.x() - player.x();
        double ry = Math.abs(Math.atan2(dy, Math.sqrt(MathUtil.fma(dz, dz, dx * dx))) - playerPitch);
        double rz = Math.abs(Math.atan2(-dx, dz) - playerYaw);
        return (ry <= ty || ry >= Math.PI * 2 - ty) && (rz <= tz || rz >= Math.PI * 2 - tz);
    }
}

