/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.function.Consumer;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CreateDummyTrackerEvent;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EventUtil;
import org.jetbrains.annotations.NotNull;

public final class DummyTracker
extends Tracker {
    private volatile PlatformLocation location;

    public DummyTracker(@NotNull PlatformLocation location, @NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
        super(pipeline, modifier);
        this.location = location;
        this.animate("spawn", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
        pipeline.scale(() -> this.scaler().scale(this));
        this.rotation(() -> new ModelRotation(this.location.pitch(), this.location.yaw()));
        preUpdateConsumer.accept(this);
        EventUtil.call(CreateDummyTrackerEvent.class, () -> new CreateDummyTrackerEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void location(@NotNull PlatformLocation location) {
        Objects.requireNonNull(location, "location");
        if (this.location.equals(location)) {
            return;
        }
        DummyTracker dummyTracker = this;
        synchronized (dummyTracker) {
            this.location = location;
            PacketBundler bundler = this.pipeline.createBundler();
            this.pipeline.forEach(b -> b.teleport(location, bundler));
            if (bundler.isNotEmpty()) {
                this.pipeline.allPlayer().forEach(bundler::send);
            }
        }
    }

    @Override
    @NotNull
    public PlatformLocation location() {
        return this.location;
    }

    public void spawn(@NotNull PlatformPlayer player) {
        PacketBundler bundler = this.pipeline.createBundler();
        this.spawn(player, bundler);
        bundler.send(player);
    }
}

