/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTag;
import kr.toxicity.model.api.bone.BoneTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoneTagRegistry {
    private final Map<String, BoneTag> byName = new HashMap<String, BoneTag>();

    BoneTagRegistry() {
        for (BoneTags value : BoneTags.values()) {
            this.addTag(value);
        }
    }

    public void addTag(@NotNull BoneTag tag) {
        for (String s : tag.tags()) {
            BoneTag checkDuplicate = this.byName.put(s, tag);
            if (checkDuplicate == null) continue;
            throw new RuntimeException("Duplicated tags: " + tag.name() + " between " + checkDuplicate.name());
        }
    }

    @NotNull
    public Optional<BoneTag> byTagName(@NotNull String tag) {
        return Optional.ofNullable(this.byTagNameOrNull(tag));
    }

    @Nullable
    public BoneTag byTagNameOrNull(@NotNull String tag) {
        return this.byName.get(tag);
    }

    @NotNull
    public BoneName parse(@NotNull String rawName) {
        String[] tagArray = (rawName = rawName.toLowerCase(Locale.ROOT)).split("_");
        if (tagArray.length < 2) {
            return new BoneName(Collections.emptySet(), rawName, rawName);
        }
        List<String> tagList = List.of(tagArray);
        int maxSize = tagList.size() - 1;
        HashSet<BoneTag> set = new HashSet<BoneTag>(maxSize);
        for (String s : tagList) {
            BoneTag tag = this.byTagNameOrNull(s);
            if (tag != null && set.size() < maxSize) {
                set.add(tag);
                continue;
            }
            return new BoneName(Collections.unmodifiableSet(set), String.join((CharSequence)"_", tagList.subList(set.size(), tagList.size())), rawName);
        }
        return new BoneName(Collections.unmodifiableSet(set), String.join((CharSequence)"_", tagList.subList(set.size(), tagList.size())), rawName);
    }
}

