/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import com.google.gson.JsonDeserializer;
import java.util.Objects;
import java.util.Set;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record BoneName(@NotNull @Unmodifiable Set<BoneTag> tags, @NotNull String name, @NotNull String rawName) {
    public static final JsonDeserializer<BoneName> PARSER = (json, typeOfT, context) -> BoneName.of(json.getAsString());

    @NotNull
    public static BoneName of(@NotNull String rawName) {
        return BoneTag.REGISTRY.parse(rawName);
    }

    public boolean tagged(BoneTag ... tags) {
        for (BoneTag boneTag : tags) {
            if (!this.tags.contains(boneTag)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BoneItemMapper toItemMapper() {
        return this.tags.isEmpty() ? BoneItemMapper.EMPTY : this.tags.stream().map(BoneTag::itemMapper).filter(Objects::nonNull).findFirst().orElse(BoneItemMapper.EMPTY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BoneName)) {
            return false;
        }
        BoneName boneName = (BoneName)o;
        return this.rawName.equals(boneName.rawName);
    }

    @Override
    public int hashCode() {
        return this.rawName.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.rawName;
    }
}

