/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record BoneMovement(@NotNull Vector3f position, @NotNull Vector3f scale, @NotNull Quaternionf rotation, @NotNull Vector3f rawRotation) {
    public BoneMovement() {
        this(new Vector3f(), new Vector3f(1.0f), new Quaternionf(), new Vector3f());
    }

    @NotNull
    public BoneMovement set(@NotNull BoneMovement movement) {
        this.position.set((Vector3fc)movement.position);
        this.scale.set((Vector3fc)movement.scale);
        this.rotation.set((Quaternionfc)movement.rotation);
        this.rawRotation.set((Vector3fc)movement.rawRotation);
        return this;
    }

    @NotNull
    public BoneMovement lerp(@NotNull BoneMovement to, float alpha, @NotNull BoneMovement dest) {
        InterpolationUtil.lerp(this.position, to.position, alpha, dest.position);
        InterpolationUtil.lerp(this.scale, to.scale, alpha, dest.scale);
        MathUtil.toQuaternion(InterpolationUtil.lerp(this.rawRotation, to.rawRotation, alpha, dest.rawRotation), dest.rotation);
        return dest;
    }
}

