/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.raw.ModelGroup;
import kr.toxicity.model.api.data.raw.ModelLoadContext;
import kr.toxicity.model.api.util.CollectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public sealed interface ModelOutliner {
    public static final JsonDeserializer<ModelOutliner> PARSER = (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new Reference(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonArray children = json.getAsJsonObject().getAsJsonArray("children");
            return new Tree((ModelGroup)context.deserialize(json, ModelGroup.class), children.asList().stream().map(child -> (ModelOutliner)context.deserialize(child, ModelOutliner.class)).toList());
        }
        throw new RuntimeException();
    };

    @NotNull
    public BlueprintElement toBlueprint(@NotNull ModelLoadContext var1);

    @NotNull
    public Stream<ModelOutliner> flatten();

    @NotNull
    public String uuid();

    public record Reference(@NotNull String uuid) implements ModelOutliner
    {
        @Override
        @NotNull
        public BlueprintElement toBlueprint(@NotNull ModelLoadContext context) {
            return Objects.requireNonNull(context.elements.get(this.uuid())).toBlueprint();
        }

        @Override
        @NotNull
        public Stream<ModelOutliner> flatten() {
            return Stream.of(this);
        }
    }

    public record Tree(@NotNull ModelGroup group, @NotNull @Unmodifiable List<ModelOutliner> children) implements ModelOutliner
    {
        @Override
        @NotNull
        public BlueprintElement toBlueprint(@NotNull ModelLoadContext context) {
            List<BlueprintElement> child = CollectionUtil.mapToList(this.children, c -> c.toBlueprint(context));
            List<BlueprintElement.Cube> filtered = CollectionUtil.filterIsInstance(child, BlueprintElement.Cube.class).toList();
            ModelGroup selectedGroup = context.groups.getOrDefault(this.uuid(), this.group);
            return new BlueprintElement.Group(UUID.fromString(selectedGroup.uuid()), BoneName.of(selectedGroup.name()), selectedGroup.origin(), selectedGroup.rotation().invertXZ(), child, filtered.isEmpty() ? selectedGroup.visibility() : filtered.stream().anyMatch(BlueprintElement.Cube::visibility));
        }

        @Override
        @NotNull
        public Stream<ModelOutliner> flatten() {
            return this.children.isEmpty() ? Stream.of(this) : Stream.concat(Stream.of(this), this.children.stream().flatMap(ModelOutliner::flatten));
        }

        @Override
        @NotNull
        public String uuid() {
            return this.group.uuid();
        }
    }
}

