/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.data.blueprint.BlueprintImage;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.pack.PackObfuscator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public record ModelBlueprint(@NotNull String name, @NotNull ModelResolution resolution, @NotNull List<BlueprintTexture> textures, @NotNull List<BlueprintElement> elements, @NotNull Map<String, BlueprintAnimation> animations) {
    public boolean hasTexture() {
        return this.textures.stream().anyMatch(BlueprintTexture::canBeRendered);
    }

    @NotNull
    public @Unmodifiable Stream<BlueprintImage> buildImage(@NotNull PackObfuscator obfuscator) {
        return this.textures.stream().filter(BlueprintTexture::canBeRendered).map(texture -> new BlueprintImage(texture.packName(obfuscator), texture.image(), texture.isAnimatedTexture() ? texture.toMcmeta() : null));
    }
}

