/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bukkit.platform;

import java.util.UUID;
import kr.toxicity.model.api.bukkit.BetterModelBukkit;
import kr.toxicity.model.api.bukkit.platform.BukkitEntity;
import kr.toxicity.model.api.bukkit.platform.BukkitItemStack;
import kr.toxicity.model.api.bukkit.platform.BukkitLivingEntity;
import kr.toxicity.model.api.bukkit.platform.BukkitLocation;
import kr.toxicity.model.api.bukkit.platform.BukkitOfflinePlayer;
import kr.toxicity.model.api.bukkit.platform.BukkitPlayer;
import kr.toxicity.model.api.bukkit.platform.BukkitWorld;
import kr.toxicity.model.api.platform.PlatformAdapter;
import kr.toxicity.model.api.platform.PlatformEntity;
import kr.toxicity.model.api.platform.PlatformItemStack;
import kr.toxicity.model.api.platform.PlatformLivingEntity;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.platform.PlatformOfflinePlayer;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.platform.PlatformWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitAdapter
implements PlatformAdapter {
    @NotNull
    public static PlatformEntity adapt(@NotNull Entity entity) {
        return new BukkitEntity(entity);
    }

    @NotNull
    public static PlatformLivingEntity adapt(@NotNull LivingEntity livingEntity) {
        return new BukkitLivingEntity(livingEntity);
    }

    @NotNull
    public static PlatformOfflinePlayer adapt(@NotNull OfflinePlayer player) {
        return new BukkitOfflinePlayer(player);
    }

    @NotNull
    public static PlatformPlayer adapt(@NotNull Player player) {
        return new BukkitPlayer(player);
    }

    @NotNull
    public static PlatformItemStack adapt(@NotNull ItemStack itemStack) {
        return new BukkitItemStack(itemStack);
    }

    @NotNull
    public static PlatformLocation adapt(@NotNull Location location) {
        return new BukkitLocation(location);
    }

    @NotNull
    public static PlatformWorld adapt(@NotNull World world) {
        return new BukkitWorld(world);
    }

    @Override
    @Nullable
    public PlatformPlayer player(@NotNull UUID uuid) {
        Player bukkit = Bukkit.getPlayer((UUID)uuid);
        return bukkit != null ? BukkitAdapter.adapt(bukkit) : null;
    }

    @Override
    @NotNull
    public PlatformOfflinePlayer offlinePlayer(@NotNull UUID uuid) {
        return BukkitAdapter.adapt(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    @Override
    public int serverViewDistance() {
        return Bukkit.getViewDistance();
    }

    @Override
    public boolean isTickThread() {
        return Bukkit.isPrimaryThread();
    }

    @Override
    public boolean isRegionSafe() {
        return !BetterModelBukkit.IS_FOLIA || this.isTickThread();
    }

    @Override
    @NotNull
    public PlatformItemStack air() {
        return BukkitAdapter.adapt(new ItemStack(Material.AIR));
    }

    @Override
    @NotNull
    public PlatformLocation zero() {
        return BukkitAdapter.adapt(new Location(null, 0.0, 0.0, 0.0));
    }
}

