/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bukkit.entity;

import java.util.Objects;
import kr.toxicity.model.api.bukkit.platform.BukkitAdapter;
import kr.toxicity.model.api.bukkit.platform.BukkitEntity;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.util.TransformedItemStack;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BaseBukkitEntity
extends BaseEntity,
PersistentDataHolder {
    @NotNull
    public static final NamespacedKey TRACKING_ID = Objects.requireNonNull(NamespacedKey.fromString((String)"bettermodel_tracker"));

    @NotNull
    default public Entity entity() {
        return ((BukkitEntity)this.platform()).source();
    }

    @Override
    @NotNull
    default public TransformedItemStack mainHand() {
        LivingEntity livingEntity;
        EntityEquipment equipment;
        Entity entity = this.entity();
        if (entity instanceof LivingEntity && (equipment = (livingEntity = (LivingEntity)entity).getEquipment()) != null) {
            return TransformedItemStack.of(BukkitAdapter.adapt(equipment.getItemInMainHand()));
        }
        return TransformedItemStack.empty();
    }

    @Override
    @NotNull
    default public TransformedItemStack offHand() {
        LivingEntity livingEntity;
        EntityEquipment equipment;
        Entity entity = this.entity();
        if (entity instanceof LivingEntity && (equipment = (livingEntity = (LivingEntity)entity).getEquipment()) != null) {
            return TransformedItemStack.of(BukkitAdapter.adapt(equipment.getItemInOffHand()));
        }
        return TransformedItemStack.empty();
    }

    @Override
    @Nullable
    default public String modelData() {
        return (String)this.getPersistentDataContainer().get(TRACKING_ID, PersistentDataType.STRING);
    }

    @Override
    default public void modelData(@Nullable String modelData) {
        PersistentDataContainer container = this.getPersistentDataContainer();
        if (modelData == null) {
            container.remove(TRACKING_ID);
        } else {
            container.set(TRACKING_ID, PersistentDataType.STRING, (Object)modelData);
        }
    }
}

