/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.function.Function;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.platform.PlatformItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record TransformedItemStack(@NotNull Vector3f position, @NotNull Vector3f offset, @NotNull Vector3f scale, @NotNull PlatformItemStack itemStack) {
    @NotNull
    public static TransformedItemStack empty() {
        return TransformedItemStack.of(BetterModel.platform().adapter().air());
    }

    @NotNull
    public static TransformedItemStack of(@NotNull PlatformItemStack itemStack) {
        return TransformedItemStack.of(new Vector3f(), new Vector3f(), new Vector3f(1.0f), itemStack);
    }

    @NotNull
    public static TransformedItemStack of(@NotNull Vector3f position, @NotNull Vector3f offset, @NotNull Vector3f scale2, @NotNull PlatformItemStack itemStack) {
        return new TransformedItemStack(position, offset, scale2, itemStack);
    }

    @NotNull
    public TransformedItemStack asAir() {
        return TransformedItemStack.of(this.position, this.offset, this.scale, BetterModel.platform().adapter().air());
    }

    @NotNull
    public TransformedItemStack offset(@NotNull Vector3f offset) {
        return TransformedItemStack.of(this.position, offset, this.scale, this.itemStack);
    }

    @NotNull
    public TransformedItemStack modify(@NotNull Function<PlatformItemStack, PlatformItemStack> mapper) {
        return TransformedItemStack.of(this.position, this.offset, this.scale, mapper.apply(this.itemStack.clone()));
    }

    public boolean isAir() {
        return this.itemStack.isAir();
    }

    @NotNull
    public TransformedItemStack copy() {
        return new TransformedItemStack(new Vector3f((Vector3fc)this.position), new Vector3f((Vector3fc)this.offset), new Vector3f((Vector3fc)this.scale), this.itemStack.clone());
    }
}

