/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.nms;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kr.toxicity.model.api.event.ModelDamagedEvent;
import kr.toxicity.model.api.event.ModelInteractAtEvent;
import kr.toxicity.model.api.event.ModelInteractEvent;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.platform.PlatformEntity;
import org.jetbrains.annotations.NotNull;

public interface HitBoxListener {
    public static final HitBoxListener EMPTY = HitBoxListener.builder().build();

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    default public Builder toBuilder() {
        return new Builder().sync(this::sync).damage(this::damage).interact(this::interact).interactAt(this::interactAt).remove(this::remove).mount(this::mount).dismount(this::dismount);
    }

    public void sync(@NotNull HitBox var1);

    public void damage(@NotNull ModelDamagedEvent var1);

    public void interact(@NotNull ModelInteractEvent var1);

    public void interactAt(@NotNull ModelInteractAtEvent var1);

    public void remove(@NotNull HitBox var1);

    public void mount(@NotNull HitBox var1, @NotNull PlatformEntity var2);

    public void dismount(@NotNull HitBox var1, @NotNull PlatformEntity var2);

    public static class Builder {
        private static final Consumer<HitBox> DEFAULT_SYNC = h -> {};
        private static final Consumer<ModelDamagedEvent> DEFAULT_DAMAGE = h -> {};
        private static final Consumer<ModelInteractEvent> DEFAULT_INTERACT = h -> {};
        private static final Consumer<ModelInteractAtEvent> DEFAULT_INTERACT_AT = h -> {};
        private static final Consumer<HitBox> DEFAULT_REMOVE = h -> {};
        private static final BiConsumer<HitBox, PlatformEntity> DEFAULT_MOUNT = (h, e) -> {};
        private static final BiConsumer<HitBox, PlatformEntity> DEFAULT_DISMOUNT = (h, e) -> {};
        private Consumer<HitBox> sync = DEFAULT_SYNC;
        private Consumer<ModelDamagedEvent> damage = DEFAULT_DAMAGE;
        private Consumer<ModelInteractEvent> interact = DEFAULT_INTERACT;
        private Consumer<ModelInteractAtEvent> interactAt = DEFAULT_INTERACT_AT;
        private Consumer<HitBox> remove = DEFAULT_REMOVE;
        private BiConsumer<HitBox, PlatformEntity> mount = DEFAULT_MOUNT;
        private BiConsumer<HitBox, PlatformEntity> dismount = DEFAULT_DISMOUNT;

        private Builder() {
        }

        @NotNull
        public Builder sync(@NotNull Consumer<HitBox> sync) {
            this.sync = this.sync == DEFAULT_SYNC ? sync : this.sync.andThen(sync);
            return this;
        }

        @NotNull
        public Builder damage(@NotNull Consumer<ModelDamagedEvent> damage) {
            this.damage = this.damage == DEFAULT_DAMAGE ? damage : this.damage.andThen(damage);
            return this;
        }

        @NotNull
        public Builder interact(@NotNull Consumer<ModelInteractEvent> interact) {
            this.interact = this.interact == DEFAULT_INTERACT ? interact : this.interact.andThen(interact);
            return this;
        }

        @NotNull
        public Builder interactAt(@NotNull Consumer<ModelInteractAtEvent> interactAt) {
            this.interactAt = this.interactAt == DEFAULT_INTERACT_AT ? interactAt : this.interactAt.andThen(interactAt);
            return this;
        }

        @NotNull
        public Builder remove(@NotNull Consumer<HitBox> remove) {
            this.remove = this.remove == DEFAULT_REMOVE ? remove : this.remove.andThen(remove);
            return this;
        }

        @NotNull
        public Builder mount(@NotNull BiConsumer<HitBox, PlatformEntity> mount) {
            this.mount = this.mount == DEFAULT_MOUNT ? mount : this.mount.andThen(mount);
            return this;
        }

        @NotNull
        public Builder dismount(@NotNull BiConsumer<HitBox, PlatformEntity> dismount) {
            this.dismount = this.dismount == DEFAULT_DISMOUNT ? dismount : this.dismount.andThen(dismount);
            return this;
        }

        @NotNull
        public HitBoxListener build() {
            return new HitBoxListener(){

                @Override
                public void sync(@NotNull HitBox hitBox) {
                    sync.accept(hitBox);
                }

                @Override
                public void damage(@NotNull ModelDamagedEvent event) {
                    damage.accept(event);
                }

                @Override
                public void interact(@NotNull ModelInteractEvent event) {
                    interact.accept(event);
                }

                @Override
                public void interactAt(@NotNull ModelInteractAtEvent event) {
                    interactAt.accept(event);
                }

                @Override
                public void remove(@NotNull HitBox hitBox) {
                    remove.accept(hitBox);
                }

                @Override
                public void mount(@NotNull HitBox hitBox, @NotNull PlatformEntity PlatformEntity2) {
                    mount.accept(hitBox, PlatformEntity2);
                }

                @Override
                public void dismount(@NotNull HitBox hitBox, @NotNull PlatformEntity PlatformEntity2) {
                    dismount.accept(hitBox, PlatformEntity2);
                }
            };
        }
    }
}

