/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.entity;

import java.util.Optional;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.nms.Identifiable;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.platform.PlatformEntity;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.util.TransformedItemStack;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface BaseEntity
extends Identifiable {
    @NotNull
    public static BaseEntity of(@NotNull PlatformEntity entity) {
        if (entity instanceof PlatformPlayer) {
            PlatformPlayer player = (PlatformPlayer)entity;
            PlayerChannelHandler channel = BetterModel.platform().playerManager().player(player.uuid());
            return channel != null ? channel.base() : BetterModel.nms().adapt(player);
        }
        return BetterModel.nms().adapt(entity);
    }

    @NotNull
    public PlatformEntity platform();

    @NotNull
    default public PlatformLocation location() {
        return this.platform().location();
    }

    @Nullable
    public Component customName();

    @NotNull
    public Object handle();

    @Override
    public int id();

    public boolean dead();

    public boolean ground();

    public boolean invisible();

    public boolean glow();

    public boolean onWalk();

    public boolean fly();

    public double scale();

    public float pitch();

    public float bodyYaw();

    public float headYaw();

    public float damageTick();

    public float walkSpeed();

    @NotNull
    public Vector3f passengerPosition(@NotNull Vector3f var1);

    @NotNull
    public Stream<PlatformPlayer> trackedBy();

    @NotNull
    public TransformedItemStack mainHand();

    @NotNull
    public TransformedItemStack offHand();

    @NotNull
    default public Optional<EntityTrackerRegistry> registry() {
        return BetterModel.registry(this.uuid());
    }

    default public boolean hasControllingPassenger() {
        EntityTrackerRegistry registry = this.registry().orElse(null);
        return registry != null && registry.hasControllingPassenger();
    }

    default public boolean hasModelData() {
        return this.modelData() != null;
    }

    @Nullable
    public String modelData();

    public void modelData(@Nullable String var1);
}

