/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.raw.ModelKeyframe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelAnimator(@Nullable BoneName name, @Nullable List<ModelKeyframe> keyframes, @SerializedName(value="rotation_global") @Nullable Boolean _rotationGlobal) {
    @Nullable
    private final BoneName name;
    @Nullable
    private final List<ModelKeyframe> keyframes;

    public boolean rotationGlobal() {
        return Boolean.TRUE.equals(this._rotationGlobal);
    }

    public boolean isAvailable() {
        return this.name != null && this.isNotEmpty();
    }

    public boolean isNotEmpty() {
        return !this.keyframes().isEmpty();
    }

    @NotNull
    public BoneName name() {
        return Objects.requireNonNull(this.name);
    }

    @NotNull
    public List<ModelKeyframe> keyframes() {
        return this.keyframes != null ? this.keyframes : Collections.emptyList();
    }

    @NotNull
    public Stream<ModelKeyframe> stream() {
        return this.keyframes().stream().filter(ModelKeyframe::hasPoint).sorted();
    }
}

