/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bukkit.event;

import java.util.function.Consumer;
import java.util.function.Supplier;
import kr.toxicity.model.api.event.ModelEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BetterModelBukkitEvent
extends Event {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Class<? extends ModelEvent> eventClass;
    @NotNull
    private final Supplier<? extends ModelEvent> supplier;
    private volatile ModelEvent source;

    @ApiStatus.Internal
    public BetterModelBukkitEvent(@NotNull Class<? extends ModelEvent> eventClass, @NotNull Supplier<? extends ModelEvent> supplier) {
        super(!Bukkit.isPrimaryThread());
        this.eventClass = eventClass;
        this.supplier = supplier;
    }

    public <T extends ModelEvent> boolean is(@NotNull Class<T> eventClass) {
        return eventClass.isAssignableFrom(this.eventClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends ModelEvent> T as(@NotNull Class<T> eventClass) {
        if (!this.is(eventClass)) {
            return null;
        }
        ModelEvent event = this.source;
        if (event == null) {
            BetterModelBukkitEvent betterModelBukkitEvent = this;
            synchronized (betterModelBukkitEvent) {
                event = this.source;
                if (event == null) {
                    event = this.source = this.supplier.get();
                }
            }
        }
        return (T)((ModelEvent)eventClass.cast(event));
    }

    public <T extends ModelEvent> void as(@NotNull Class<T> eventClass, @NotNull Consumer<? super T> consumer) {
        T get = this.as(eventClass);
        if (get != null) {
            consumer.accept(get);
        }
    }

    @ApiStatus.Internal
    @Nullable
    public ModelEvent source() {
        return this.source;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

