/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneRenderContext;
import kr.toxicity.model.api.bone.BoneTag;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.nms.Profiled;
import kr.toxicity.model.api.platform.PlatformItemTransform;
import kr.toxicity.model.api.player.PlayerLimb;
import kr.toxicity.model.api.util.TransformedItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public enum BoneTags implements BoneTag
{
    HEAD("h"),
    HEAD_WITH_CHILDREN("hi"),
    HITBOX("b", "ob"),
    SEAT("p"),
    SUB_SEAT("sp"),
    TAG("tag"),
    MOB_TAG("mtag"),
    PLAYER_TAG("ptag"),
    LEFT_ITEM(BoneItemMapper.entity(PlatformItemTransform.THIRDPERSON_LEFTHAND, BaseEntity::offHand), "pli", "li"),
    RIGHT_ITEM(BoneItemMapper.entity(PlatformItemTransform.THIRDPERSON_RIGHTHAND, BaseEntity::mainHand), "pri", "ri"),
    PLAYER_HEAD(PlayerLimb.HEAD.getItemMapper(), "ph"),
    PLAYER_RIGHT_ARM(PlayerLimb.RIGHT_ARM.getItemMapper(), "pra"),
    PLAYER_RIGHT_FOREARM(PlayerLimb.RIGHT_FOREARM.getItemMapper(), "prfa"),
    PLAYER_LEFT_ARM(PlayerLimb.LEFT_ARM.getItemMapper(), "pla"),
    PLAYER_LEFT_FOREARM(PlayerLimb.LEFT_FOREARM.getItemMapper(), "plfa"),
    PLAYER_HIP(PlayerLimb.HIP.getItemMapper(), "phip"),
    PLAYER_WAIST(PlayerLimb.WAIST.getItemMapper(), "pw"),
    PLAYER_CHEST(PlayerLimb.CHEST.getItemMapper(), "pc"),
    PLAYER_RIGHT_LEG(PlayerLimb.RIGHT_LEG.getItemMapper(), "prl"),
    PLAYER_RIGHT_FORELEG(PlayerLimb.RIGHT_FORELEG.getItemMapper(), "prfl"),
    PLAYER_LEFT_LEG(PlayerLimb.LEFT_LEG.getItemMapper(), "pll"),
    PLAYER_LEFT_FORELEG(PlayerLimb.LEFT_FORELEG.getItemMapper(), "plfl"),
    CAPE(new BoneItemMapper(){

        @Override
        @NotNull
        public TransformedItemStack apply(@NotNull BoneRenderContext context, @NotNull TransformedItemStack transformedItemStack) {
            Profiled profiled;
            RenderSource<?> renderSource;
            TransformedItemStack cape = null;
            if (BetterModel.platform().skinManager().supported() && (renderSource = context.source()) instanceof Profiled && (profiled = (Profiled)((Object)renderSource)).skinParts().isCapeEnabled()) {
                cape = context.skin().cape(profiled.armors());
            }
            return cape != null ? cape : TransformedItemStack.empty();
        }

        @Override
        @NotNull
        public PlatformItemTransform transform() {
            return PlatformItemTransform.FIXED;
        }
    }, "cape");

    @Nullable
    private final BoneItemMapper itemMapper;
    @NotNull
    private final List<String> tags;

    private BoneTags(String ... tags) {
        this((BoneItemMapper)null, tags);
    }

    private BoneTags(BoneItemMapper itemMapper, String ... tags) {
        this.itemMapper = itemMapper;
        this.tags = List.of(tags);
    }

    @Override
    @Nullable
    public BoneItemMapper itemMapper() {
        return this.itemMapper;
    }

    @Override
    @NotNull
    public @Unmodifiable List<String> tags() {
        return this.tags;
    }
}

