/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.function.BiFunction;
import java.util.function.Function;
import kr.toxicity.model.api.bone.BoneRenderContext;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.entity.BasePlayer;
import kr.toxicity.model.api.platform.PlatformItemTransform;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.util.TransformedItemStack;
import org.jetbrains.annotations.NotNull;

public interface BoneItemMapper
extends BiFunction<BoneRenderContext, TransformedItemStack, TransformedItemStack> {
    public static final BoneItemMapper EMPTY = new BoneItemMapper(){

        @Override
        @NotNull
        public PlatformItemTransform transform() {
            return PlatformItemTransform.FIXED;
        }

        @Override
        @NotNull
        public TransformedItemStack apply(@NotNull BoneRenderContext context, @NotNull TransformedItemStack transformedItemStack) {
            return transformedItemStack;
        }
    };

    @Override
    @NotNull
    public TransformedItemStack apply(@NotNull BoneRenderContext var1, @NotNull TransformedItemStack var2);

    @NotNull
    public static BoneItemMapper player(final @NotNull PlatformItemTransform transform, final @NotNull Function<PlatformPlayer, TransformedItemStack> mapper) {
        return new BoneItemMapper(){
            private static final TransformedItemStack AIR = TransformedItemStack.empty();

            @Override
            @NotNull
            public PlatformItemTransform transform() {
                return transform;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @NotNull
            public TransformedItemStack apply(@NotNull BoneRenderContext context, @NotNull TransformedItemStack transformedItemStack) {
                BasePlayer basePlayer2;
                RenderSource<?> renderSource = context.source();
                if (!(renderSource instanceof RenderSource.BasePlayer)) return transformedItemStack;
                RenderSource.BasePlayer basePlayer = (RenderSource.BasePlayer)renderSource;
                try {
                    basePlayer2 = basePlayer.entity();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (!(basePlayer2 instanceof PlatformPlayer)) return transformedItemStack;
                PlatformPlayer player = (PlatformPlayer)((Object)basePlayer2);
                TransformedItemStack get = (TransformedItemStack)mapper.apply(player);
                return get == null ? AIR : get;
            }
        };
    }

    @NotNull
    public static BoneItemMapper entity(final @NotNull PlatformItemTransform transform, final @NotNull Function<BaseEntity, TransformedItemStack> mapper) {
        return new BoneItemMapper(){
            private static final TransformedItemStack AIR = TransformedItemStack.empty();

            @Override
            @NotNull
            public PlatformItemTransform transform() {
                return transform;
            }

            @Override
            @NotNull
            public TransformedItemStack apply(@NotNull BoneRenderContext context, @NotNull TransformedItemStack transformedItemStack) {
                RenderSource<?> renderSource = context.source();
                if (renderSource instanceof RenderSource.Entity) {
                    RenderSource.Entity entity = (RenderSource.Entity)renderSource;
                    TransformedItemStack get = (TransformedItemStack)mapper.apply(entity.entity());
                    return get == null ? AIR : get;
                }
                return transformedItemStack;
            }
        };
    }

    default public boolean fixed() {
        return this.transform() == PlatformItemTransform.FIXED;
    }

    @NotNull
    public PlatformItemTransform transform();
}

