/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.armormodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorColor;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorCustomModelData;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorNamespaceKey;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorTrimPalette;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ArmorDataResult(@NotNull ArmorNamespaceKey key, @Nullable JsonObject armor, @Nullable JsonObject armorTrim) {
    public static final int WHITE_INDEX = 0xFFFFFF;

    @NotNull
    public JsonObject build() {
        JsonObject json = new JsonObject();
        json.add("model", (JsonElement)this.toJson());
        return json;
    }

    @NotNull
    public JsonObject toJson() {
        if (this.armor != null && this.armorTrim != null) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)this.armor);
            array.add((JsonElement)this.armorTrim);
            return ArmorUtil.compositeJson(array);
        }
        if (this.armor != null) {
            return this.armor;
        }
        return this.armorTrim != null ? this.armorTrim : ArmorUtil.EMPTY;
    }

    @NotNull
    public ArmorCustomModelData customModelData(@NotNull String type) {
        return this.customModelData(type, 0xFFFFFF);
    }

    @NotNull
    public ArmorCustomModelData customModelData(@NotNull String type, int armorTint) {
        return new ArmorCustomModelData(this.key, Collections.singletonList(type), IntList.of((int[])new int[]{armorTint, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF}));
    }

    @NotNull
    public ArmorCustomModelData customModelData(@NotNull String type, @NotNull String trim, @Nullable ArmorTrimPalette palette) {
        return this.customModelData(type, 0xFFFFFF, trim, palette);
    }

    @NotNull
    public ArmorCustomModelData customModelData(@NotNull String type, int armorTint, @NotNull String trim, @Nullable ArmorTrimPalette palette) {
        if (palette == null) {
            return this.customModelData(type, armorTint);
        }
        IntArrayList list = new IntArrayList(9);
        list.add(armorTint);
        for (ArmorColor armorColor : palette.palettes()) {
            list.add(armorColor.rgb());
        }
        return new ArmorCustomModelData(this.key, List.of(type, trim), (IntList)list);
    }
}

