/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.entity.BasePlayer;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.platform.PlatformEntity;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.tracker.EntityHideOption;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.LogUtil;
import kr.toxicity.model.api.util.lock.DuplexLock;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class EntityTrackerRegistry {
    private static final Object2ReferenceMap<UUID, EntityTrackerRegistry> UUID_REGISTRY_MAP = new Object2ReferenceOpenHashMap();
    private static final Int2ReferenceMap<EntityTrackerRegistry> ID_REGISTRY_MAP = new Int2ReferenceOpenHashMap();
    private static final DuplexLock REGISTRY_LOCK = new DuplexLock();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean loaded = new AtomicBoolean();
    private final BaseEntity entity;
    private final int id;
    private final UUID uuid;
    private final ConcurrentNavigableMap<String, EntityTracker> trackerMap = new ConcurrentSkipListMap<String, EntityTracker>();
    private final Collection<EntityTracker> trackers = Collections.unmodifiableCollection(this.trackerMap.values());
    private final Map<UUID, PlayerChannelCache> viewedPlayerMap = new ConcurrentHashMap<UUID, PlayerChannelCache>();
    final Map<UUID, MountedHitBox> mountedHitBoxCache = new ConcurrentHashMap<UUID, MountedHitBox>();
    private final Map<UUID, MountedHitBox> mountedHitBox = Collections.unmodifiableMap(this.mountedHitBoxCache);

    @Nullable
    public static EntityTrackerRegistry registry(@NotNull UUID uuid) {
        return REGISTRY_LOCK.accessToReadLock(() -> (EntityTrackerRegistry)UUID_REGISTRY_MAP.get((Object)uuid));
    }

    @Nullable
    public static EntityTrackerRegistry registry(int id) {
        return REGISTRY_LOCK.accessToReadLock(() -> (EntityTrackerRegistry)ID_REGISTRY_MAP.get(id));
    }

    @Nullable
    public static EntityTrackerRegistry registry(@NotNull BaseEntity entity) {
        EntityTrackerRegistry get = EntityTrackerRegistry.registry(entity.uuid());
        if (get != null) {
            return get;
        }
        return entity.hasModelData() ? EntityTrackerRegistry.create(entity) : null;
    }

    public static void registries(@NotNull Consumer<EntityTrackerRegistry> consumer) {
        for (EntityTrackerRegistry registry : EntityTrackerRegistry.registries()) {
            consumer.accept(registry);
        }
    }

    @NotNull
    public static @Unmodifiable List<EntityTrackerRegistry> registries() {
        return (List)REGISTRY_LOCK.accessToReadLock(() -> ImmutableList.copyOf((Collection)UUID_REGISTRY_MAP.values()));
    }

    @ApiStatus.Internal
    @NotNull
    public static EntityTrackerRegistry getOrCreate(@NotNull BaseEntity entity) {
        EntityTrackerRegistry get = EntityTrackerRegistry.registry(entity.uuid());
        return get != null ? get : EntityTrackerRegistry.create(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static EntityTrackerRegistry create(@NotNull BaseEntity entity) {
        EntityTrackerRegistry registry;
        UUID uuid;
        UUID uUID = uuid = entity.uuid();
        synchronized (uUID) {
            EntityTrackerRegistry get2 = EntityTrackerRegistry.registry(uuid);
            if (get2 != null) {
                return get2;
            }
            registry = new EntityTrackerRegistry(entity);
            REGISTRY_LOCK.accessToWriteLock(() -> {
                UUID_REGISTRY_MAP.put((Object)registry.uuid, (Object)registry);
                ID_REGISTRY_MAP.put(registry.id, (Object)registry);
                return null;
            });
        }
        registry.initialLoad();
        return registry;
    }

    @NotNull
    private static Collection<JsonElement> deserialize(@Nullable String raw) {
        if (raw == null) {
            return Collections.emptyList();
        }
        JsonElement json = JsonParser.parseString((String)raw);
        return json.isJsonArray() ? json.getAsJsonArray().asList() : Collections.singletonList(json);
    }

    private EntityTrackerRegistry(@NotNull BaseEntity entity) {
        this.entity = entity;
        this.uuid = entity.uuid();
        this.id = entity.id();
    }

    @NotNull
    public BaseEntity entity() {
        return this.entity;
    }

    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    public int id() {
        return this.id;
    }

    @NotNull
    public @Unmodifiable Collection<EntityTracker> trackers() {
        return this.trackers;
    }

    @Nullable
    public EntityTracker tracker(@Nullable String key) {
        return key == null ? this.first() : (EntityTracker)this.trackerMap.get(key);
    }

    @Nullable
    public EntityTracker first() {
        Map.Entry entry = this.trackerMap.firstEntry();
        return entry != null ? (EntityTracker)entry.getValue() : null;
    }

    @ApiStatus.Internal
    @NotNull
    public EntityTracker create(@NotNull String key, @NotNull Function<EntityTrackerRegistry, EntityTracker> supplier) {
        EntityTracker created = supplier.apply(this);
        if (this.putTracker(key, created)) {
            this.refreshSpawn();
            this.save();
        }
        return created;
    }

    @ApiStatus.Internal
    @NotNull
    public EntityTracker getOrCreate(@NotNull String key, @NotNull Function<EntityTrackerRegistry, EntityTracker> supplier) {
        EntityTracker get = (EntityTracker)this.trackerMap.get(key);
        return get != null ? get : this.create(key, supplier);
    }

    private boolean putTracker(@NotNull String key, @NotNull EntityTracker created) {
        if (this.isClosed() || created.isClosed()) {
            return false;
        }
        created.handleCloseEvent((t, r) -> {
            if (this.isClosed()) {
                return;
            }
            if (this.trackerMap.compute(key, (k, v) -> v == created ? null : v) == null) {
                LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> String.valueOf(this.uuid) + "'s tracker " + key + " has been removed. (" + this.trackerMap.size() + ")");
            }
            if (this.trackerMap.isEmpty()) {
                this.close((Tracker.CloseReason)((Object)r));
            } else {
                this.refreshRemove();
            }
        });
        EntityTracker previous = this.trackerMap.put(key, created);
        if (previous != null) {
            previous.close();
        }
        return true;
    }

    private void refreshSpawn() {
        this.viewedPlayer().forEach(value -> this.spawnIfNotSpawned(value.player()));
    }

    private void refreshRemove() {
        for (PlayerChannelCache value : this.viewedPlayerMap.values()) {
            value.hide();
        }
    }

    private void initialLoad() {
        if (BetterModel.platform().adapter().isRegionSafe() && this.loaded.compareAndSet(false, true)) {
            this.load();
            this.refreshPlayer();
        }
    }

    private void refreshPlayer() {
        this.entity.trackedBy().map(p -> BetterModel.player(p.uuid()).orElse(null)).filter(Objects::nonNull).forEach(this::registerPlayer);
    }

    public boolean remove(@NotNull String key) {
        try (EntityTracker removed = (EntityTracker)this.trackerMap.remove(key);){
            this.save();
            boolean bl = removed != null;
            return bl;
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean close() {
        return this.close(Tracker.CloseReason.REMOVE);
    }

    public boolean close(@NotNull Tracker.CloseReason reason) {
        if (!this.closed.compareAndSet(false, true)) {
            return false;
        }
        this.viewedPlayer().forEach(value -> value.sendEntityData(this));
        this.viewedPlayerMap.clear();
        for (EntityTracker value2 : this.trackers()) {
            value2.close(reason);
        }
        if (!reason.shouldBeSave()) {
            this.runSync(() -> this.entity.modelData(null));
        }
        REGISTRY_LOCK.accessToWriteLock(() -> {
            UUID_REGISTRY_MAP.remove((Object)this.uuid);
            ID_REGISTRY_MAP.remove(this.id);
            BaseEntity patt0$temp = this.entity;
            if (patt0$temp instanceof BasePlayer) {
                BasePlayer player = (BasePlayer)patt0$temp;
                player.updateInventory();
            }
            return null;
        });
        LogUtil.debug(DebugConfig.DebugOption.TRACKER, () -> String.valueOf(this.uuid) + "'s tracker registry has been removed. (" + UUID_REGISTRY_MAP.size() + ")");
        return true;
    }

    public void reload() {
        this.closed.set(true);
        ArrayList<TrackerData> data = new ArrayList<TrackerData>(this.trackerMap.size());
        for (EntityTracker value : this.trackers()) {
            if (!value.canBeSaved()) continue;
            data.add(value.asTrackerData());
            value.close();
        }
        this.trackerMap.clear();
        this.closed.set(false);
        this.load(data.stream());
    }

    public void refresh() {
        if (this.entity.dead()) {
            return;
        }
        for (EntityTracker value : this.trackers()) {
            value.refresh();
        }
        this.refreshPlayer();
        this.refreshSpawn();
    }

    public void despawn() {
        for (EntityTracker value : this.trackers()) {
            if (value.forRemoval()) continue;
            value.despawn();
        }
        this.viewedPlayerMap.clear();
    }

    public void load(@NotNull Stream<TrackerData> stream) {
        stream.forEach(parsed -> BetterModel.model(parsed.id()).ifPresent(model2 -> model2.create(this.entity, parsed.modifier(), parsed::applyAs)));
        this.save();
    }

    public void load() {
        this.load(EntityTrackerRegistry.deserialize(this.entity.modelData()).stream().map(TrackerData::deserialize));
    }

    public void save() {
        JsonArray data = this.serialize();
        if (!data.isEmpty()) {
            this.runSync(() -> this.entity.modelData(data.toString()));
        }
    }

    private void runSync(@NotNull Runnable runnable) {
        if (BetterModel.platform().adapter().isTickThread()) {
            runnable.run();
        } else {
            this.entity.platform().task(runnable);
        }
    }

    @NotNull
    public Stream<ModelDisplay> displays() {
        return this.trackers().stream().flatMap(Tracker::displays);
    }

    @NotNull
    public JsonArray serialize() {
        return CollectionUtil.mapToJson(this.trackers().stream().filter(EntityTracker::canBeSaved), value -> value.asTrackerData().serialize());
    }

    public boolean isSpawned(@NotNull PlatformPlayer player) {
        return this.isSpawned(player.uuid());
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.viewedPlayerMap.containsKey(uuid) && this.trackers().stream().anyMatch(t -> t.isSpawned(uuid));
    }

    public boolean spawn(@NotNull PlatformPlayer player) {
        this.initialLoad();
        return this.spawn(player, false);
    }

    public boolean spawnIfNotSpawned(@NotNull PlatformPlayer player) {
        this.initialLoad();
        return this.spawn(player, true);
    }

    private boolean spawn(@NotNull PlatformPlayer player, boolean shouldNotSpawned) {
        PlayerChannelHandler handler = BetterModel.platform().playerManager().player(player.uuid());
        if (handler == null) {
            return false;
        }
        PlayerChannelCache cache = this.registerPlayer(handler);
        if (this.trackerMap.isEmpty()) {
            return false;
        }
        PacketBundler bundler = BetterModel.nms().createBundler(10);
        for (EntityTracker value : this.trackers()) {
            if (shouldNotSpawned && value.isSpawned(player) || !value.canBeSpawnedAt(player)) continue;
            value.spawn(player, bundler);
        }
        if (bundler.isEmpty()) {
            return false;
        }
        BetterModel.nms().mount(this, bundler);
        cache.spawn(bundler);
        return true;
    }

    @NotNull
    private PlayerChannelCache registerPlayer(@NotNull PlayerChannelHandler handler) {
        return this.viewedPlayerMap.computeIfAbsent(handler.uuid(), u -> new PlayerChannelCache(handler));
    }

    @NotNull
    public Stream<PlayerChannelHandler> viewedPlayer() {
        return this.viewedPlayerMap.values().stream().map(c -> c.channelHandler);
    }

    public boolean remove(@NotNull PlatformPlayer player) {
        PlayerChannelCache cache = this.viewedPlayerMap.remove(player.uuid());
        if (cache == null) {
            return false;
        }
        PlayerChannelHandler handler = cache.channelHandler;
        handler.sendEntityData(this);
        for (EntityTracker value : this.trackers()) {
            if (value.forRemoval() || !value.isSpawned(player)) continue;
            value.remove(handler.player());
        }
        return true;
    }

    @NotNull
    public EntityHideOption hideOption(@NotNull UUID uuid) {
        PlayerChannelCache cache = this.viewedPlayerMap.get(uuid);
        return cache != null ? cache.hideOption : EntityHideOption.FALSE;
    }

    @NotNull
    public @Unmodifiable Map<UUID, MountedHitBox> mountedHitBox() {
        return this.mountedHitBox;
    }

    public boolean hasPassenger() {
        return !this.mountedHitBox().isEmpty();
    }

    public boolean hasControllingPassenger() {
        return this.mountedHitBox().values().stream().map(MountedHitBox::hitBox).anyMatch(HitBox::hasBeenControlled);
    }

    @Generated
    public String toString() {
        return "EntityTrackerRegistry(closed=" + String.valueOf(this.closed) + ", entity=" + String.valueOf(this.entity) + ", trackers=" + String.valueOf(this.trackers) + ")";
    }

    private class PlayerChannelCache {
        private final PlayerChannelHandler channelHandler;
        private volatile EntityHideOption hideOption = EntityHideOption.DEFAULT;

        private void hide() {
            this.reapplyHideOption();
            BetterModel.nms().hide(this.channelHandler, EntityTrackerRegistry.this);
        }

        private void spawn(@NotNull PacketBundler bundler) {
            this.reapplyHideOption();
            bundler.send(this.channelHandler.player(), () -> BetterModel.nms().hide(this.channelHandler, EntityTrackerRegistry.this, () -> EntityTrackerRegistry.this.viewedPlayerMap.containsKey(this.channelHandler.uuid())));
        }

        private synchronized void reapplyHideOption() {
            this.hideOption = EntityHideOption.composite(EntityTrackerRegistry.this.trackers().stream().filter(t -> t.isSpawned(this.channelHandler.uuid())).map(EntityTracker::hideOption));
        }

        @Generated
        public PlayerChannelCache(PlayerChannelHandler channelHandler) {
            this.channelHandler = channelHandler;
        }
    }

    public record MountedHitBox(@NotNull RenderedBone bone, @NotNull PlatformEntity entity, @NotNull HitBox hitBox) {
        public void dismount() {
            this.hitBox.dismount(this.entity);
        }

        public void dismountAll() {
            this.hitBox.dismountAll();
        }
    }
}

