/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTag;
import kr.toxicity.model.api.bone.BoneTags;
import org.jetbrains.annotations.NotNull;

public final class BoneTagRegistry {
    private final Map<String, BoneTag> byName = new HashMap<String, BoneTag>();

    BoneTagRegistry() {
        for (BoneTags value : BoneTags.values()) {
            this.addTag(value);
        }
    }

    public void addTag(@NotNull BoneTag tag) {
        for (String s : tag.tags()) {
            BoneTag checkDuplicate = this.byName.put(s, tag);
            if (checkDuplicate == null) continue;
            throw new RuntimeException("Duplicated tags: " + tag.name() + " between " + checkDuplicate.name());
        }
    }

    @NotNull
    public Optional<BoneTag> byTagName(@NotNull String tag) {
        return Optional.ofNullable(this.byName.get(tag));
    }

    @NotNull
    public BoneName parse(@NotNull String rawName) {
        List<String> tagArray = List.of((rawName = rawName.toLowerCase(Locale.ROOT)).split("_"));
        if (tagArray.size() < 2) {
            return new BoneName(Collections.emptySet(), rawName, rawName);
        }
        int maxSize = tagArray.size() - 1;
        HashSet<BoneTag> set = new HashSet<BoneTag>(maxSize);
        for (String s : tagArray) {
            BoneTag tag = this.byTagName(s).orElse(null);
            if (tag != null && set.size() < maxSize) {
                set.add(tag);
                continue;
            }
            return new BoneName(Collections.unmodifiableSet(set), String.join((CharSequence)"_", tagArray.subList(set.size(), tagArray.size())), rawName);
        }
        return new BoneName(Collections.unmodifiableSet(set), String.join((CharSequence)"_", tagArray.subList(set.size(), tagArray.size())), rawName);
    }
}

