/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.JsonArray;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public record EntityHideOption(boolean equipment, boolean fire, boolean visibility, boolean glowing) {
    public static final EntityHideOption DEFAULT = new EntityHideOption(true, true, true, true);
    public static final EntityHideOption FALSE = EntityHideOption.builder().build();

    @NotNull
    public static EntityHideOption composite(@NotNull Stream<EntityHideOption> options) {
        return EntityHideOption.builder().composite(options).build();
    }

    @NotNull
    public static EntityHideOption deserialize(@NotNull JsonArray array) {
        return new EntityHideOption(array.get(0).getAsBoolean(), array.get(1).getAsBoolean(), array.get(2).getAsBoolean(), array.get(3).getAsBoolean());
    }

    @NotNull
    public JsonArray serialize() {
        JsonArray array = new JsonArray(4);
        array.add(Boolean.valueOf(this.equipment));
        array.add(Boolean.valueOf(this.fire));
        array.add(Boolean.valueOf(this.visibility));
        array.add(Boolean.valueOf(this.glowing));
        return array;
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean equipment;
        private boolean fire;
        private boolean visibility;
        private boolean glowing;

        private Builder() {
        }

        @NotNull
        public Builder composite(@NotNull Stream<EntityHideOption> options) {
            options.forEach(this::or);
            return this;
        }

        @NotNull
        public Builder or(@NotNull EntityHideOption option) {
            this.equipment = this.equipment || option.equipment;
            this.fire = this.fire || option.fire;
            this.visibility = this.visibility || option.visibility;
            this.glowing = this.glowing || option.glowing;
            return this;
        }

        @NotNull
        public EntityHideOption build() {
            return new EntityHideOption(this.equipment, this.fire, this.visibility, this.glowing);
        }
    }
}

