/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.profile;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.platform.PlatformOfflinePlayer;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.profile.ModelProfileInfo;
import kr.toxicity.model.api.profile.ModelProfileSkin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ModelProfile {
    public static final ModelProfile UNKNOWN = ModelProfile.of(ModelProfileInfo.UNKNOWN);

    @NotNull
    public static ModelProfile of(@NotNull ModelProfileInfo info) {
        return new Simple(info, ModelProfileSkin.EMPTY);
    }

    @NotNull
    public static ModelProfile of(@NotNull ModelProfileInfo info, @NotNull ModelProfileSkin skin) {
        return new Simple(info, skin);
    }

    @NotNull
    public static ModelProfile of(@NotNull PlatformPlayer player) {
        PlayerChannelHandler channel = BetterModel.platform().playerManager().player(player.uuid());
        return channel != null ? channel.base().profile() : BetterModel.nms().profile(player);
    }

    @NotNull
    public static Uncompleted of(@NotNull PlatformOfflinePlayer offlinePlayer) {
        return BetterModel.platform().profileManager().supplier().supply(offlinePlayer);
    }

    @NotNull
    public static Uncompleted of(@NotNull UUID uuid) {
        return ModelProfile.of(BetterModel.platform().adapter().offlinePlayer(uuid));
    }

    @NotNull
    public ModelProfileInfo info();

    @NotNull
    public ModelProfileSkin skin();

    @NotNull
    default public Uncompleted asUncompleted() {
        return new Uncompleted(){

            @Override
            @NotNull
            public ModelProfileInfo info() {
                return ModelProfile.this.info();
            }

            @Override
            @NotNull
            public CompletableFuture<ModelProfile> complete() {
                return CompletableFuture.completedFuture(ModelProfile.this);
            }
        };
    }

    @Nullable
    default public PlatformPlayer player() {
        return BetterModel.platform().adapter().player(this.info().id());
    }

    public record Simple(@NotNull ModelProfileInfo info, @NotNull ModelProfileSkin skin) implements ModelProfile
    {
    }

    public static interface Uncompleted {
        @NotNull
        public ModelProfileInfo info();

        @NotNull
        public CompletableFuture<ModelProfile> complete();

        @NotNull
        default public ModelProfile fallback() {
            return ModelProfile.of(this.info());
        }
    }
}

