/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.armor.PlayerArmor;
import kr.toxicity.model.api.bone.BoneRenderContext;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.nms.Profiled;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.player.PlayerSkinParts;
import kr.toxicity.model.api.profile.ModelProfile;
import kr.toxicity.model.api.skin.SkinData;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import kr.toxicity.model.api.tracker.PlayerTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface RenderSource<T extends Tracker> {
    @ApiStatus.Internal
    @NotNull
    public static Dummy of(@NotNull PlatformLocation location) {
        return new BaseDummy(location);
    }

    @ApiStatus.Internal
    @NotNull
    public static Dummy of(@NotNull PlatformLocation location, @NotNull ModelProfile.Uncompleted profile) {
        return new ProfiledDummy(location, profile);
    }

    @ApiStatus.Internal
    @NotNull
    public static Entity of(@NotNull kr.toxicity.model.api.entity.BaseEntity entity, @NotNull ModelProfile.Uncompleted profile) {
        Record record;
        if (entity instanceof kr.toxicity.model.api.entity.BasePlayer) {
            kr.toxicity.model.api.entity.BasePlayer player = (kr.toxicity.model.api.entity.BasePlayer)entity;
            record = new ProfiledPlayer(player, profile);
        } else {
            record = new ProfiledEntity(entity, profile);
        }
        return record;
    }

    @ApiStatus.Internal
    @NotNull
    public static Entity of(@NotNull kr.toxicity.model.api.entity.BaseEntity entity) {
        Record record;
        if (entity instanceof kr.toxicity.model.api.entity.BasePlayer) {
            kr.toxicity.model.api.entity.BasePlayer player = (kr.toxicity.model.api.entity.BasePlayer)entity;
            record = new BasePlayer(player);
        } else {
            record = new BaseEntity(entity);
        }
        return record;
    }

    @NotNull
    public PlatformLocation location();

    public T create(@NotNull RenderPipeline var1, @NotNull TrackerModifier var2, @NotNull Consumer<T> var3);

    @NotNull
    public CompletableFuture<BoneRenderContext> completeContext();

    default public BoneRenderContext fallbackContext() {
        return new BoneRenderContext(this);
    }

    public record BaseDummy(@NotNull PlatformLocation location) implements Dummy
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
            return new DummyTracker(this.location, pipeline, modifier, preUpdateConsumer);
        }

        @Override
        @NotNull
        public CompletableFuture<BoneRenderContext> completeContext() {
            return CompletableFuture.completedFuture(this.fallbackContext());
        }
    }

    public record ProfiledDummy(@NotNull PlatformLocation location, @NotNull ModelProfile.Uncompleted profile) implements Dummy
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<DummyTracker> preUpdateConsumer) {
            return new DummyTracker(this.location, pipeline, modifier, preUpdateConsumer);
        }

        @Override
        @NotNull
        public CompletableFuture<BoneRenderContext> completeContext() {
            return BetterModel.platform().skinManager().complete(this.profile).thenApply(skin -> new BoneRenderContext(this, (SkinData)skin));
        }
    }

    public static final class ProfiledPlayer
    extends Record
    implements Entity,
    Profiled {
        @NotNull
        private final kr.toxicity.model.api.entity.BasePlayer entity;
        @NotNull
        private final ModelProfile.Uncompleted externalProfile;

        public ProfiledPlayer(@NotNull kr.toxicity.model.api.entity.BasePlayer entity, @NotNull ModelProfile.Uncompleted externalProfile) {
            this.entity = entity;
            this.externalProfile = externalProfile;
        }

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new PlayerTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new PlayerTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public PlatformLocation location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public CompletableFuture<BoneRenderContext> completeContext() {
            return BetterModel.platform().skinManager().complete(this.externalProfile).thenApply(skin -> new BoneRenderContext(this, (SkinData)skin));
        }

        @Override
        @NotNull
        public ModelProfile profile() {
            return this.entity.profile();
        }

        @Override
        @NotNull
        public PlayerArmor armors() {
            return this.entity.armors();
        }

        @Override
        @NotNull
        public PlayerSkinParts skinParts() {
            return this.entity.skinParts();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProfiledPlayer.class, "entity;externalProfile", "entity", "externalProfile"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProfiledPlayer.class, "entity;externalProfile", "entity", "externalProfile"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProfiledPlayer.class, "entity;externalProfile", "entity", "externalProfile"}, this, o);
        }

        @Override
        @NotNull
        public kr.toxicity.model.api.entity.BasePlayer entity() {
            return this.entity;
        }

        @NotNull
        public ModelProfile.Uncompleted externalProfile() {
            return this.externalProfile;
        }
    }

    public record ProfiledEntity(@NotNull kr.toxicity.model.api.entity.BaseEntity entity, @NotNull ModelProfile.Uncompleted profile) implements Entity
    {
        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new EntityTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new EntityTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public PlatformLocation location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public CompletableFuture<BoneRenderContext> completeContext() {
            return BetterModel.platform().skinManager().complete(this.profile).thenApply(skin -> new BoneRenderContext(this, (SkinData)skin));
        }
    }

    public static final class BasePlayer
    extends Record
    implements Entity,
    Profiled {
        @NotNull
        private final kr.toxicity.model.api.entity.BasePlayer entity;

        public BasePlayer(@NotNull kr.toxicity.model.api.entity.BasePlayer entity) {
            this.entity = entity;
        }

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new PlayerTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new PlayerTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public PlatformLocation location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public CompletableFuture<BoneRenderContext> completeContext() {
            return BetterModel.platform().skinManager().complete(this.profile().asUncompleted()).thenApply(skin -> new BoneRenderContext(this, (SkinData)skin));
        }

        @Override
        @NotNull
        public ModelProfile profile() {
            return this.entity.profile();
        }

        @Override
        @NotNull
        public PlayerArmor armors() {
            return this.entity.armors();
        }

        @Override
        @NotNull
        public PlayerSkinParts skinParts() {
            return this.entity.skinParts();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this, o);
        }

        @Override
        @NotNull
        public kr.toxicity.model.api.entity.BasePlayer entity() {
            return this.entity;
        }
    }

    public record BaseEntity(@NotNull kr.toxicity.model.api.entity.BaseEntity entity) implements Entity
    {
        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).create(pipeline.name(), r -> new EntityTracker((EntityTrackerRegistry)r, pipeline, modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public EntityTracker getOrCreate(@NotNull String name, @NotNull Supplier<RenderPipeline> supplier, @NotNull TrackerModifier modifier, @NotNull Consumer<EntityTracker> preUpdateConsumer) {
            return EntityTrackerRegistry.getOrCreate(this.entity).getOrCreate(name, r -> new EntityTracker((EntityTrackerRegistry)r, (RenderPipeline)supplier.get(), modifier, preUpdateConsumer));
        }

        @Override
        @NotNull
        public PlatformLocation location() {
            return this.entity.location();
        }

        @Override
        @NotNull
        public CompletableFuture<BoneRenderContext> completeContext() {
            return CompletableFuture.completedFuture(this.fallbackContext());
        }
    }

    public static sealed interface Dummy
    extends RenderSource<DummyTracker>
    permits BaseDummy, ProfiledDummy {
    }

    public static sealed interface Entity
    extends RenderSource<EntityTracker>
    permits BaseEntity, ProfiledEntity, BasePlayer, ProfiledPlayer {
        @NotNull
        public kr.toxicity.model.api.entity.BaseEntity entity();

        @NotNull
        public EntityTracker getOrCreate(@NotNull String var1, @NotNull Supplier<RenderPipeline> var2, @NotNull TrackerModifier var3, @NotNull Consumer<EntityTracker> var4);
    }
}

