/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.function;

import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import java.util.Objects;
import java.util.function.Function;
import kr.toxicity.model.api.util.MathUtil;
import kr.toxicity.model.api.util.function.FloatConstantFunction;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface FloatFunction<T> {
    @NotNull
    public T apply(float var1);

    @NotNull
    public static <T> FloatConstantFunction<T> of(@NotNull T t) {
        return new FloatConstantFunction<T>(Objects.requireNonNull(t));
    }

    @NotNull
    default public <R> FloatFunction<R> map(@NotNull Function<T, R> mapper) {
        return f -> mapper.apply(this.apply(f));
    }

    @NotNull
    default public FloatFunction<T> memoize() {
        Int2ReferenceOpenHashMap map = new Int2ReferenceOpenHashMap();
        return f -> map.computeIfAbsent(MathUtil.similarHashCode(f), i2 -> this.apply(f));
    }
}

