/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bukkit.platform;

import kr.toxicity.model.api.bukkit.BetterModelBukkit;
import kr.toxicity.model.api.bukkit.platform.BukkitAdapter;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.platform.PlatformWorld;
import kr.toxicity.model.api.scheduler.ModelTask;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BukkitLocation(@NotNull Location source) implements PlatformLocation
{
    @Override
    @NotNull
    public PlatformWorld world() {
        return BukkitAdapter.adapt(this.source.getWorld());
    }

    @Override
    public double x() {
        return this.source.getX();
    }

    @Override
    public double y() {
        return this.source.getY();
    }

    @Override
    public double z() {
        return this.source.getZ();
    }

    @Override
    public float pitch() {
        return this.source.getPitch();
    }

    @Override
    public float yaw() {
        return this.source.getYaw();
    }

    @Override
    @NotNull
    public PlatformLocation add(double x, double y, double z) {
        return BukkitAdapter.adapt(this.source.clone().add(x, y, z));
    }

    @Override
    @Nullable
    public ModelTask task(@NotNull Runnable runnable) {
        return BetterModelBukkit.platform().scheduler().task(this.source, runnable);
    }

    @Override
    @Nullable
    public ModelTask taskLater(long delay, @NotNull Runnable runnable) {
        return BetterModelBukkit.platform().scheduler().taskLater(this.source, delay, runnable);
    }
}

