/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import kr.toxicity.model.api.animation.AnimationEventHandler;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.animation.Timed;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AnimationStateHandler<T extends Timed> {
    private final T initialValue;
    private final BiConsumer<T, T> setConsumer;
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private final Collection<TreeIterator> reversedView = this.animators.sequencedValues().reversed();
    private final AtomicBoolean forceUpdateAnimation = new AtomicBoolean();
    private int delay;
    private volatile TreeIterator currentIterator = null;
    private volatile KeyframeData beforeKeyframe = null;
    private volatile KeyframeData afterKeyframe = null;

    public boolean keyframeFinished() {
        return this.delay <= 0;
    }

    public T beforeKeyframe() {
        return this.value(this.beforeKeyframe);
    }

    public T afterKeyframe() {
        return this.value(this.afterKeyframe);
    }

    @NotNull
    public T beforeKeyframe(@NotNull T defaultValue) {
        T value = this.value(this.beforeKeyframe);
        return value != null ? value : defaultValue;
    }

    @NotNull
    public T afterKeyframe(@NotNull T defaultValue) {
        T value = this.value(this.afterKeyframe);
        return value != null ? value : defaultValue;
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        TreeIterator iterator = this.currentIterator;
        return iterator != null ? iterator.animation : null;
    }

    public boolean tick() {
        return this.tick(() -> {});
    }

    public boolean tick(@NotNull Runnable ifEmpty) {
        --this.delay;
        if (this.animators.isEmpty()) {
            ifEmpty.run();
            return false;
        }
        return this.shouldUpdateAnimation() && this.updateAnimation();
    }

    public float progress() {
        float frame = this.frame();
        return frame == 0.0f ? 0.0f : Math.clamp((float)this.delay / frame, 0.0f, 1.0f);
    }

    private boolean shouldUpdateAnimation() {
        return this.forceUpdateAnimation.compareAndSet(true, false) || this.afterKeyframe != null && this.keyframeFinished() || this.delay % 5 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator = this.reversedView.iterator();
            while (iterator.hasNext()) {
                TreeIterator next = iterator.next();
                if (!next.getAsBoolean()) continue;
                if (this.currentIterator == null) {
                    if (!this.updateKeyframe(iterator, next)) continue;
                    this.currentIterator = next;
                    return this.setAfterKeyframe(next.next());
                }
                if (this.currentIterator != next) {
                    if (!this.updateKeyframe(iterator, next)) continue;
                    this.currentIterator.clear();
                    this.currentIterator = next;
                    return this.setAfterKeyframe(next.next());
                }
                if (this.keyframeFinished()) {
                    if (!this.updateKeyframe(iterator, next)) continue;
                    return this.setAfterKeyframe(next.next());
                }
                return false;
            }
        }
        return this.setAfterKeyframe(null);
    }

    private boolean updateKeyframe(@NotNull Iterator<TreeIterator> iterator, @NotNull TreeIterator next) {
        if (!next.hasNext()) {
            next.eventHandler.animationRemove();
            iterator.remove();
            return false;
        }
        return true;
    }

    private boolean setAfterKeyframe(@Nullable KeyframeData next) {
        if (this.equals(this.afterKeyframe, next)) {
            return false;
        }
        this.beforeKeyframe = this.afterKeyframe;
        this.afterKeyframe = next;
        this.setConsumer.accept(this.value(this.beforeKeyframe), this.value(this.afterKeyframe));
        this.delay = Math.round(this.frame());
        return true;
    }

    private boolean equals(@Nullable KeyframeData from, @Nullable KeyframeData to) {
        if (from == null && to == null) {
            return true;
        }
        if (from == null || to == null) {
            return false;
        }
        return from.value == to.value && from.realTime == to.realTime;
    }

    @Nullable
    private T value(@Nullable KeyframeData data) {
        return data == null ? null : (T)data.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimation(@NotNull String name, @NotNull AnimationIterator<T> iterator, @NotNull AnimationModifier modifier, @NotNull AnimationEventHandler eventHandler) {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            this.animators.putLast(name, new TreeIterator(name, iterator, modifier, eventHandler));
        }
        this.forceUpdateAnimation.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAnimation(@NotNull String name, @NotNull AnimationIterator<T> iterator, @NotNull AnimationModifier modifier) {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            this.animators.computeIfPresent(name, (k, v) -> new TreeIterator((String)k, iterator, v.modifier.toBuilder().mergeNotDefault(modifier).build(), v.eventHandler));
        }
        this.forceUpdateAnimation.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopAnimation(@NotNull String name) {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            if (this.animators.remove(name) != null) {
                this.forceUpdateAnimation.set(true);
                return true;
            }
        }
        return false;
    }

    public float frame() {
        return this.afterKeyframe != null ? 100.0f * (this.afterKeyframe.realTime + 0.001f) : 0.0f;
    }

    @Generated
    public AnimationStateHandler(T initialValue, BiConsumer<T, T> setConsumer) {
        this.initialValue = initialValue;
        this.setConsumer = setConsumer;
    }

    @Generated
    public int getDelay() {
        return this.delay;
    }

    private class KeyframeData {
        private final T value;
        private final float realTime;

        /*
         * WARNING - Possible parameter corruption
         */
        @Generated
        public KeyframeData(T value, float realTime) {
            this.value = value;
            this.realTime = realTime;
        }
    }

    private class TreeIterator
    implements BooleanSupplier {
        private final RunningAnimation animation;
        private final AnimationIterator<T> iterator;
        private final AnimationModifier modifier;
        private final AnimationEventHandler eventHandler;
        private final T previous;
        private boolean started = false;
        private boolean ended = false;

        public TreeIterator(String name, AnimationIterator<T> iterator, AnimationModifier modifier, AnimationEventHandler eventHandler) {
            this.animation = new RunningAnimation(name, iterator.type());
            this.iterator = iterator;
            this.modifier = modifier;
            this.eventHandler = eventHandler;
            this.previous = AnimationStateHandler.this.afterKeyframe != null ? AnimationStateHandler.this.afterKeyframe.value : AnimationStateHandler.this.initialValue;
        }

        @Override
        public boolean getAsBoolean() {
            return this.modifier.predicateValue();
        }

        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        @NotNull
        public KeyframeData next() {
            if (!this.started) {
                this.started = true;
                return new KeyframeData(AnimationStateHandler.this, (Timed)this.iterator.next(), (float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return new KeyframeData(AnimationStateHandler.this, this.previous, (float)this.modifier.end() / 20.0f);
            }
            Timed nxt = (Timed)this.iterator.next();
            return new KeyframeData(AnimationStateHandler.this, nxt, nxt.time() / this.modifier.speedValue());
        }

        public void clear() {
            this.iterator.clear();
            this.ended = !this.iterator.hasNext();
            this.started = this.ended;
        }
    }
}

