/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.List;
import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.animation.TimedStorage;
import kr.toxicity.model.api.bone.BoneMovement;
import org.jetbrains.annotations.NotNull;

public interface AnimationProgress
extends Timed {
    public static final AnimationProgress EMPTY = AnimationProgress.empty(0.0f);

    public boolean skipInterpolation();

    public boolean globalRotation();

    @NotNull
    public static AnimationProgress empty(float time) {
        return new EmptyProgress(time);
    }

    @NotNull
    default public AnimationProgress toEmpty() {
        float time = this.time();
        return time <= 0.0f ? EMPTY : AnimationProgress.empty(time);
    }

    @NotNull
    public static TimedStorage<AnimationProgress> emptyStorage(float time) {
        return TimedStorage.listOf(List.of(EMPTY, AnimationProgress.empty(time)));
    }

    @NotNull
    public BoneMovement animate(@NotNull BoneMovement var1, @NotNull BoneMovement var2);

    public record EmptyProgress(float time) implements AnimationProgress
    {
        @Override
        @NotNull
        public BoneMovement animate(@NotNull BoneMovement movement, @NotNull BoneMovement dest) {
            return dest.set(movement);
        }

        @Override
        @NotNull
        public AnimationProgress toEmpty() {
            return this;
        }

        @Override
        public boolean skipInterpolation() {
            return false;
        }

        @Override
        public boolean globalRotation() {
            return false;
        }
    }
}

