/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelEventBus;
import kr.toxicity.model.api.BetterModelPlatform;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.nms.NMS;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.platform.PlatformEntity;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class BetterModel {
    private static BetterModelPlatform instance;

    private BetterModel() {
        throw new RuntimeException();
    }

    @NotNull
    public static BetterModelConfig config() {
        return BetterModel.platform().config();
    }

    @NotNull
    public static Optional<ModelRenderer> model(@NotNull String name) {
        return Optional.ofNullable(BetterModel.modelOrNull(name));
    }

    @Nullable
    public static ModelRenderer modelOrNull(@NotNull String name) {
        return BetterModel.platform().modelManager().model(name);
    }

    @NotNull
    public static Optional<ModelRenderer> limb(@NotNull String name) {
        return Optional.ofNullable(BetterModel.limbOrNull(name));
    }

    @Nullable
    public static ModelRenderer limbOrNull(@NotNull String name) {
        return BetterModel.platform().modelManager().limb(name);
    }

    @NotNull
    public static Optional<PlayerChannelHandler> player(@NotNull UUID uuid) {
        return Optional.ofNullable(BetterModel.platform().playerManager().player(uuid));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull UUID uuid) {
        return Optional.ofNullable(BetterModel.registryOrNull(uuid));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull PlatformEntity entity) {
        return Optional.ofNullable(BetterModel.registryOrNull(entity));
    }

    @NotNull
    public static Optional<EntityTrackerRegistry> registry(@NotNull BaseEntity entity) {
        return Optional.ofNullable(BetterModel.registryOrNull(entity));
    }

    @Nullable
    public static EntityTrackerRegistry registryOrNull(@NotNull UUID uuid) {
        return EntityTrackerRegistry.registry(uuid);
    }

    @Nullable
    public static EntityTrackerRegistry registryOrNull(@NotNull PlatformEntity entity) {
        return BetterModel.registryOrNull(BetterModel.nms().adapt(entity));
    }

    @Nullable
    public static EntityTrackerRegistry registryOrNull(@NotNull BaseEntity entity) {
        return EntityTrackerRegistry.registry(entity);
    }

    @NotNull
    public static @Unmodifiable Collection<ModelRenderer> models() {
        return BetterModel.platform().modelManager().models();
    }

    @NotNull
    public static @Unmodifiable Collection<ModelRenderer> limbs() {
        return BetterModel.platform().modelManager().limbs();
    }

    @NotNull
    public static @Unmodifiable Set<String> modelKeys() {
        return BetterModel.platform().modelManager().modelKeys();
    }

    @NotNull
    public static @Unmodifiable Set<String> limbKeys() {
        return BetterModel.platform().modelManager().limbKeys();
    }

    @NotNull
    public static BetterModelPlatform platform() {
        return Objects.requireNonNull(instance, "BetterModel hasn't been initialized yet!");
    }

    @NotNull
    public static NMS nms() {
        return BetterModel.platform().nms();
    }

    @NotNull
    public static BetterModelEventBus eventBus() {
        return BetterModel.platform().eventBus();
    }

    @ApiStatus.Internal
    public static void register(@NotNull BetterModelPlatform instance) {
        Objects.requireNonNull(instance, "instance cannot be null.");
        if (BetterModel.instance == instance) {
            throw new RuntimeException("Duplicated instance.");
        }
        BetterModel.instance = instance;
    }
}

