/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.platform.PlatformBillboard;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public sealed interface TrackerUpdateAction
extends BiPredicate<RenderedBone, BonePredicate> {
    @NotNull
    public static Brightness brightness(int block, int sky) {
        return new Brightness(block, sky);
    }

    @NotNull
    public static Glow glow(boolean glow) {
        return glow ? Glow.TRUE : Glow.FALSE;
    }

    @NotNull
    public static GlowColor glowColor(int glowColor) {
        return new GlowColor(glowColor);
    }

    @NotNull
    public static ViewRange viewRange(float viewRange) {
        return new ViewRange(viewRange);
    }

    @NotNull
    public static Tint tint(int rgb) {
        return new Tint(rgb);
    }

    @NotNull
    public static PreviousTint previousTint() {
        return PreviousTint.INSTANCE;
    }

    @NotNull
    public static Enchant enchant(boolean enchant) {
        return enchant ? Enchant.TRUE : Enchant.FALSE;
    }

    @NotNull
    public static TogglePart togglePart(boolean toggle) {
        return toggle ? TogglePart.TRUE : TogglePart.FALSE;
    }

    @NotNull
    public static ItemStack itemStack(@NotNull TransformedItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        return new ItemStack(itemStack);
    }

    @NotNull
    public static Billboard billboard(@NotNull PlatformBillboard billboard) {
        Objects.requireNonNull(billboard);
        return new Billboard(billboard);
    }

    @NotNull
    public static ItemMapping itemMapping() {
        return ItemMapping.INSTANCE;
    }

    @NotNull
    public static MoveDuration moveDuration(int moveDuration) {
        return new MoveDuration(moveDuration);
    }

    @NotNull
    public static TrackerUpdateAction composite(TrackerUpdateAction ... actions) {
        return switch (actions.length) {
            case 0 -> TrackerUpdateAction.none();
            case 1 -> actions[0];
            default -> new Composite(Arrays.stream(actions).flatMap(TrackerUpdateAction::stream).toList());
        };
    }

    @NotNull
    public static PerBone perBone(@NotNull Function<RenderedBone, TrackerUpdateAction> builder) {
        return new PerBone(builder);
    }

    @NotNull
    public static None none() {
        return None.INSTANCE;
    }

    @Override
    public boolean test(@NotNull RenderedBone var1, @NotNull BonePredicate var2);

    @NotNull
    default public TrackerUpdateAction then(@NotNull TrackerUpdateAction action) {
        return TrackerUpdateAction.composite(this, action);
    }

    @NotNull
    default public Stream<TrackerUpdateAction> stream() {
        return Stream.of(this);
    }

    public record Brightness(int block, int sky) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.brightness(this.block, this.sky));
        }
    }

    public static enum Glow implements TrackerUpdateAction
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;

        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.glow(this.value));
        }

        @Generated
        private Glow(boolean value) {
            this.value = value;
        }
    }

    public record GlowColor(int glowColor) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.glowColor(this.glowColor));
        }
    }

    public record ViewRange(float viewRange) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.viewRange(this.viewRange));
        }
    }

    public record Tint(int rgb) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.tint(predicate, this.rgb);
        }
    }

    public static enum PreviousTint implements TrackerUpdateAction
    {
        INSTANCE;


        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.tint(predicate);
        }
    }

    public static enum Enchant implements TrackerUpdateAction
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;

        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.enchant(predicate, this.value);
        }

        @Generated
        private Enchant(boolean value) {
            this.value = value;
        }
    }

    public static enum TogglePart implements TrackerUpdateAction
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;

        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.invisible(!this.value));
        }

        @Generated
        private TogglePart(boolean value) {
            this.value = value;
        }
    }

    public record ItemStack(@NotNull TransformedItemStack itemStack) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.itemStack(predicate, this.itemStack);
        }
    }

    public record Billboard(@NotNull PlatformBillboard billboard) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.billboard(this.billboard));
        }
    }

    public static enum ItemMapping implements TrackerUpdateAction
    {
        INSTANCE;


        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.updateItem(predicate);
        }
    }

    public record MoveDuration(int moveDuration) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.applyAtDisplay(predicate, display -> display.moveDuration(this.moveDuration));
        }
    }

    public static enum None implements TrackerUpdateAction
    {
        INSTANCE;


        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return false;
        }
    }

    public record Composite(@NotNull @Unmodifiable List<TrackerUpdateAction> actions) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            boolean result = false;
            for (TrackerUpdateAction action : this.actions) {
                if (!action.test(bone, predicate)) continue;
                result = true;
            }
            return result;
        }

        @Override
        @NotNull
        public Stream<TrackerUpdateAction> stream() {
            return this.actions.stream().flatMap(TrackerUpdateAction::stream);
        }
    }

    public record PerBone(@NotNull Function<RenderedBone, TrackerUpdateAction> builder) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return this.builder.apply(bone).test(bone, predicate);
        }
    }
}

