/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationPredicate;
import kr.toxicity.model.api.animation.RunningAnimation;
import kr.toxicity.model.api.bone.BoneEventDispatcher;
import kr.toxicity.model.api.bone.BoneEventHandler;
import kr.toxicity.model.api.bone.BoneIKSolver;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.platform.PlatformPlayer;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.function.BonePredicate;
import kr.toxicity.model.api.util.function.FloatSupplier;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class RenderPipeline
implements BoneEventHandler {
    private final ModelRenderer parent;
    private final RenderSource<?> source;
    private final Map<BoneName, RenderedBone> boneMap;
    private final Map<BoneName, RenderedBone> flattenBoneMap;
    private final int displayAmount;
    private final Map<UUID, SpawnedPlayer> playerMap = new ConcurrentHashMap<UUID, SpawnedPlayer>();
    private final Set<UUID> hidePlayerSet = ConcurrentHashMap.newKeySet();
    private final BoneEventDispatcher eventDispatcher = new BoneEventDispatcher();
    private final BoneIKSolver ikSolver;
    private Predicate<PlatformPlayer> viewFilter = p -> true;
    private Predicate<PlatformPlayer> hideFilter = p -> this.hidePlayerSet.contains(p.uuid());
    private Consumer<PacketBundler> spawnPacketHandler = b -> {};
    private Consumer<PacketBundler> despawnPacketHandler = b -> {};
    private Consumer<PacketBundler> hidePacketHandler = b -> {};
    private Consumer<PacketBundler> showPacketHandler = b -> {};
    private ModelRotation rotation = ModelRotation.INVALID;

    public RenderPipeline(@NotNull ModelRenderer parent, @NotNull RenderSource<?> source, @NotNull Map<BoneName, RenderedBone> boneMap) {
        this.parent = parent;
        this.source = source;
        this.boneMap = boneMap;
        this.flattenBoneMap = CollectionUtil.associate(boneMap.values().stream().flatMap(RenderedBone::flatten).peek(bone -> bone.extend(this)), RenderedBone::name);
        this.ikSolver = new BoneIKSolver(CollectionUtil.associate(this.flattenBoneMap.values(), RenderedBone::uuid));
        this.displayAmount = (int)this.flattenBoneMap.values().stream().peek(bone -> bone.locator(this.ikSolver)).filter(rb -> rb.getDisplay() != null).count();
    }

    @NotNull
    public PacketBundler createBundler() {
        return BetterModel.nms().createBundler(this.displayAmount + 1);
    }

    @Nullable
    public PlayerChannelHandler channel(@NotNull UUID uuid) {
        SpawnedPlayer get = this.playerMap.get(uuid);
        return get != null ? get.handler : null;
    }

    @NotNull
    public PacketBundler createLazyBundler() {
        return BetterModel.nms().createLazyBundler();
    }

    @NotNull
    public PacketBundler createParallelBundler() {
        int size = BetterModel.config().packetBundlingSize();
        return size <= 0 ? this.createBundler() : BetterModel.nms().createParallelBundler(size);
    }

    @Override
    @NotNull
    public BoneEventDispatcher eventDispatcher() {
        return this.eventDispatcher;
    }

    public void viewFilter(@NotNull Predicate<PlatformPlayer> filter) {
        this.viewFilter = this.viewFilter.and(Objects.requireNonNull(filter));
    }

    public void hideFilter(@NotNull Predicate<PlatformPlayer> filter) {
        this.hideFilter = this.hideFilter.or(Objects.requireNonNull(filter));
    }

    public void spawnPacketHandler(@NotNull Consumer<PacketBundler> spawnPacketHandler) {
        this.spawnPacketHandler = this.spawnPacketHandler.andThen(Objects.requireNonNull(spawnPacketHandler));
    }

    public void despawnPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.despawnPacketHandler = this.despawnPacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public void hidePacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.hidePacketHandler = this.hidePacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public void showPacketHandler(@NotNull Consumer<PacketBundler> despawnPacketHandler) {
        this.showPacketHandler = this.showPacketHandler.andThen(Objects.requireNonNull(despawnPacketHandler));
    }

    public boolean isSpawned(@NotNull UUID uuid) {
        return this.playerMap.containsKey(uuid);
    }

    @Nullable
    public RunningAnimation runningAnimation() {
        return this.firstNotNull(RenderedBone::runningAnimation);
    }

    @NotNull
    public String name() {
        return this.parent.name();
    }

    public void despawn() {
        this.hitboxes().forEach(HitBox::removeHitBox);
        PacketBundler bundler = this.createBundler();
        this.remove0(bundler);
        if (bundler.isNotEmpty()) {
            this.allPlayer().forEach(bundler::send);
        }
        this.playerMap.clear();
    }

    public boolean rotate(@NotNull ModelRotation rotation2, @NotNull PacketBundler bundler) {
        if (rotation2.equals(this.rotation)) {
            return false;
        }
        this.rotation = rotation2;
        return this.matchTree(b -> b.rotate(rotation2, bundler));
    }

    public boolean tick(@NotNull PacketBundler bundler) {
        boolean match = this.matchTree(RenderedBone::tick);
        if (match) {
            this.ikSolver.solve();
            this.iterateTree(b -> b.sendTransformation(null, bundler));
        }
        return match;
    }

    public boolean tick(@NotNull UUID uuid, @NotNull PacketBundler bundler) {
        boolean match = this.matchTree(b -> b.tick(uuid));
        if (match) {
            this.ikSolver.solve(uuid);
            this.iterateTree(b -> b.sendTransformation(uuid, bundler));
        }
        return match;
    }

    public void defaultPosition(@NotNull Function<Vector3f, Vector3f> movement) {
        Vector3f vec = new Vector3f();
        Supplier<Vector3f> supplier = FunctionUtil.throttleTick(() -> (Vector3f)movement.apply(vec));
        this.iterateTree(b -> b.defaultPosition(supplier));
    }

    public void scale(@NotNull FloatSupplier scale2) {
        this.iterateTree(b -> b.scale(scale2));
    }

    public boolean addRotationModifier(@NotNull BonePredicate predicate, @NotNull Function<Quaternionf, Quaternionf> mapper) {
        return this.matchTree(predicate, (RenderedBone b, BonePredicate p) -> b.addRotationModifier((Predicate<RenderedBone>)p, mapper));
    }

    public boolean addPositionModifier(@NotNull BonePredicate predicate, @NotNull Function<Vector3f, Vector3f> mapper) {
        return this.matchTree(predicate, (RenderedBone b, BonePredicate p) -> b.addPositionModifier((Predicate<RenderedBone>)p, mapper));
    }

    @NotNull
    public @Unmodifiable Collection<RenderedBone> bones() {
        return this.flattenBoneMap.values();
    }

    @NotNull
    public Stream<HitBox> hitboxes() {
        return this.bones().stream().map(RenderedBone::getHitBox).filter(Objects::nonNull);
    }

    @Nullable
    public RenderedBone boneOf(@NotNull BoneName name) {
        return this.flattenBoneMap.get(name);
    }

    @ApiStatus.Internal
    public boolean spawn(@NotNull PlatformPlayer player, @NotNull PacketBundler bundler, @NotNull Consumer<SpawnedPlayer> consumer) {
        PlayerChannelHandler get = BetterModel.platform().playerManager().player(player.uuid());
        if (get == null) {
            return false;
        }
        SpawnedPlayer spawnedPlayer = new SpawnedPlayer(get);
        this.playerMap.put(player.uuid(), spawnedPlayer);
        this.spawnPacketHandler.accept(bundler);
        boolean hided = this.isHide(player);
        this.iterateTree(b -> b.spawn(hided, bundler));
        consumer.accept(spawnedPlayer);
        return true;
    }

    @ApiStatus.Internal
    public boolean remove(@NotNull PlatformPlayer player) {
        if (this.playerMap.remove(player.uuid()) == null) {
            return false;
        }
        PacketBundler bundler = this.createBundler();
        this.remove0(bundler);
        bundler.send(player);
        return true;
    }

    @ApiStatus.Internal
    private void remove0(@NotNull PacketBundler bundler) {
        this.despawnPacketHandler.accept(bundler);
        this.iterateTree(b -> b.remove(bundler));
    }

    public boolean matchTree(@NotNull BonePredicate predicate, BiPredicate<RenderedBone, BonePredicate> mapper) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(mapper);
        boolean result = false;
        for (RenderedBone value : this.boneMap.values()) {
            if (!value.matchTree(predicate, mapper)) continue;
            result = true;
        }
        return result;
    }

    public boolean matchTree(@NotNull AnimationPredicate predicate, BiPredicate<RenderedBone, AnimationPredicate> mapper) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(mapper);
        boolean result = false;
        for (RenderedBone value : this.boneMap.values()) {
            if (!value.matchTree(predicate, mapper)) continue;
            result = true;
        }
        return result;
    }

    public boolean matchTree(@NotNull Predicate<RenderedBone> predicate) {
        Objects.requireNonNull(predicate);
        boolean result = false;
        for (RenderedBone value : this.boneMap.values()) {
            if (!value.matchTree(predicate)) continue;
            result = true;
        }
        return result;
    }

    public void iterateTree(@NotNull Consumer<RenderedBone> consumer) {
        Objects.requireNonNull(consumer);
        for (RenderedBone value : this.boneMap.values()) {
            value.iterateTree(consumer);
        }
    }

    @Nullable
    public <T> T firstNotNull(@NotNull Function<RenderedBone, T> mapper) {
        return this.bones().stream().map(mapper).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public int playerCount() {
        return this.playerMap.size();
    }

    @NotNull
    public Stream<PlatformPlayer> allPlayer() {
        return this.playerMap.values().stream().map(spawned -> spawned.handler.player());
    }

    @NotNull
    public Stream<PlatformPlayer> nonHidePlayer() {
        return this.playerMap.values().stream().filter(spawned -> spawned.initialLoad).map(spawned -> spawned.handler.player()).filter(this.viewFilter);
    }

    @NotNull
    public Stream<PlatformPlayer> viewedPlayer() {
        return this.allPlayer().filter(this.viewFilter);
    }

    public boolean hide(@NotNull PlatformPlayer player) {
        if (this.isHide(player) || !this.hidePlayerSet.add(player.uuid())) {
            return false;
        }
        if (this.isSpawned(player.uuid())) {
            PacketBundler bundler = this.createBundler();
            this.iterateTree(b -> b.forceUpdate(false, bundler));
            this.hidePacketHandler.accept(bundler);
            if (bundler.isNotEmpty()) {
                bundler.send(player);
            }
        }
        player.task(() -> this.hitboxes().forEach(hb -> hb.hide(player)));
        return true;
    }

    public boolean isHide(@NotNull PlatformPlayer player) {
        return this.hideFilter.test(player);
    }

    public boolean show(@NotNull PlatformPlayer player) {
        if (!this.isHide(player) || !this.hidePlayerSet.remove(player.uuid())) {
            return false;
        }
        if (this.isSpawned(player.uuid())) {
            PacketBundler bundler = this.createBundler();
            this.iterateTree(b -> b.forceUpdate(true, bundler));
            this.showPacketHandler.accept(bundler);
            if (bundler.isNotEmpty()) {
                bundler.send(player);
            }
        }
        player.task(() -> this.hitboxes().forEach(hb -> hb.show(player)));
        return true;
    }

    @Generated
    public ModelRenderer getParent() {
        return this.parent;
    }

    @Generated
    public RenderSource<?> getSource() {
        return this.source;
    }

    @Generated
    public ModelRotation getRotation() {
        return this.rotation;
    }

    public class SpawnedPlayer {
        private final PlayerChannelHandler handler;
        private boolean initialLoad;

        public void load() {
            this.initialLoad = true;
            if (RenderPipeline.this.isHide(this.handler.player())) {
                return;
            }
            PacketBundler b = RenderPipeline.this.createBundler();
            RenderPipeline.this.iterateTree(bone -> bone.forceUpdate(b));
            if (b.isNotEmpty()) {
                b.send(this.handler.player());
            }
        }

        @Generated
        public SpawnedPlayer(PlayerChannelHandler handler) {
            this.handler = handler;
        }
    }
}

