/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bone;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class BoneIKSolver {
    private static final int MAX_IK_ITERATION = 20;
    private static final float DISTANCE_THRESHOLD_SQ = 1.0000001E-6f;
    private final Map<UUID, RenderedBone> boneMap;
    private final Map<RenderedBone, IKChain> locators = new LinkedHashMap<RenderedBone, IKChain>();

    public void addLocator(@Nullable UUID ikSource, @NotNull UUID ikTarget, @NotNull RenderedBone locator) {
        RenderedBone target = this.boneMap.get(ikTarget);
        if (target == null) {
            return;
        }
        RenderedBone source = ikSource == null ? target.root : this.boneMap.getOrDefault(ikSource, target.root);
        RenderedBone[] list = (RenderedBone[])source.flatten().filter(bone -> !bone.flattenBones().contains(locator) && bone.flattenBones().contains(target)).toArray(RenderedBone[]::new);
        if (list.length < 2) {
            return;
        }
        this.locators.put(locator, new IKChain(source, list, new IKCache(list.length)));
    }

    public void solve() {
        this.solve(null);
    }

    public void solve(@Nullable UUID uuid) {
        for (Map.Entry<RenderedBone, IKChain> entry : this.locators.entrySet()) {
            RenderedBone locator = entry.getKey();
            IKChain value = entry.getValue();
            RenderedBone root = value.bones[0];
            BoneMovement[] movements = value.cache.movements;
            for (int i2 = 0; i2 < value.bones.length; ++i2) {
                movements[i2] = value.bones[i2].state(uuid).after();
            }
            BoneIKSolver.fabrik(movements, value.source.state(uuid).after().rotation().invert(value.cache.rotation), value.cache.buffer, locator.state(uuid).after().position().get(value.cache.destination).add((Vector3fc)locator.root.group.getPosition()).sub((Vector3fc)root.state(uuid).after().position()).sub((Vector3fc)root.root.group.getPosition()));
        }
    }

    private static void fabrik(@NotNull BoneMovement[] bones, @NotNull Quaternionf parentRot, float[] lengths, @NotNull Vector3f target) {
        BoneMovement next;
        Object current;
        Vector3f first = bones[0].position();
        Vector3f last = bones[bones.length - 1].position();
        Vector3f vecCache = new Vector3f();
        Vector3f rootPos = first.get(vecCache);
        for (int i2 = 0; i2 < bones.length - 1; ++i2) {
            BoneMovement before = bones[i2];
            BoneMovement after = bones[i2 + 1];
            lengths[i2] = before.position().distance((Vector3fc)after.position());
        }
        for (int iter = 0; iter < 20; ++iter) {
            float dist;
            int i3;
            last.set((Vector3fc)target);
            for (i3 = bones.length - 2; i3 >= 0; --i3) {
                current = bones[i3].position();
                dist = current.distance((Vector3fc)(next = bones[i3 + 1].position()));
                if (dist < 1.0E-5f) continue;
                InterpolationUtil.lerp((Vector3f)next, (Vector3f)current, lengths[i3] / dist, (Vector3f)current);
            }
            first.set((Vector3fc)rootPos);
            for (i3 = 0; i3 < bones.length - 1; ++i3) {
                current = bones[i3].position();
                dist = current.distance((Vector3fc)(next = bones[i3 + 1].position()));
                if (dist < 1.0E-5f) continue;
                InterpolationUtil.lerp((Vector3f)current, (Vector3f)next, lengths[i3] / dist, (Vector3f)next);
            }
            if (last.distanceSquared((Vector3fc)target) < 1.0000001E-6f) break;
        }
        Quaternionf rotCache = new Quaternionf();
        for (int i4 = 0; i4 < bones.length - 1; ++i4) {
            current = bones[i4];
            next = bones[i4 + 1];
            Vector3f dir = next.position().sub((Vector3fc)((BoneMovement)current).position(), vecCache);
            ((BoneMovement)current).rotation().set((Quaternionfc)MathUtil.fromToRotation(dir.normalize(), rotCache).mul((Quaternionfc)parentRot).mul((Quaternionfc)((BoneMovement)current).rotation()));
        }
    }

    @Generated
    public BoneIKSolver(Map<UUID, RenderedBone> boneMap) {
        this.boneMap = boneMap;
    }

    private record IKChain(@NotNull RenderedBone source, @NotNull RenderedBone[] bones, @NotNull IKCache cache) {
    }

    private record IKCache(@NotNull BoneMovement[] movements, float[] buffer, @NotNull Vector3f destination, @NotNull Quaternionf rotation) {
        private IKCache(int length) {
            this(new BoneMovement[length], new float[length - 1], new Vector3f(), new Quaternionf());
        }
    }
}

