/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.BetterModelLogger;
import kr.toxicity.model.api.util.LogUtil;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class CollectionUtil {
    private CollectionUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static <E, R> Stream<R> filterIsInstance(@NotNull Collection<E> collection, @NotNull Class<R> rClass) {
        return collection.isEmpty() ? Stream.empty() : CollectionUtil.filterIsInstance(collection.stream(), rClass);
    }

    @NotNull
    public static <E, R> @Unmodifiable List<R> mapToList(@NotNull Collection<E> collection, @NotNull Function<E, R> mapper) {
        return collection.isEmpty() ? Collections.emptyList() : CollectionUtil.mapToList(collection.stream(), mapper);
    }

    @NotNull
    public static <E, R> @Unmodifiable List<R> mapToList(@NotNull Stream<E> stream, @NotNull Function<E, R> mapper) {
        return stream.map(mapper).toList();
    }

    @NotNull
    public static <E, R> @Unmodifiable Set<R> mapToSet(@NotNull Collection<E> collection, @NotNull Function<E, R> mapper) {
        return collection.isEmpty() ? Collections.emptySet() : CollectionUtil.mapToSet(collection.stream(), mapper);
    }

    @NotNull
    public static <E, R> @Unmodifiable Set<R> mapToSet(@NotNull Stream<E> stream, @NotNull Function<E, R> mapper) {
        return stream.map(mapper).collect(Collectors.toUnmodifiableSet());
    }

    @NotNull
    public static <E, R extends JsonElement> JsonArray mapToJson(@NotNull Collection<E> collection, @NotNull Function<E, R> mapper) {
        return collection.isEmpty() ? new JsonArray() : CollectionUtil.mapToJson(collection.size(), collection.stream(), mapper);
    }

    @NotNull
    public static <E, R extends JsonElement> JsonArray mapToJson(@NotNull Stream<E> stream, @NotNull Function<E, R> mapper) {
        return CollectionUtil.mapToJson(10, stream, mapper);
    }

    @NotNull
    public static <E, R extends JsonElement> JsonArray mapToJson(int capacity, @NotNull Stream<E> stream, @NotNull Function<E, R> mapper) {
        JsonArray array = new JsonArray(capacity);
        stream.map(mapper).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    @NotNull
    public static <E, R> Stream<R> filterIsInstance(@NotNull Stream<E> stream, @NotNull Class<R> rClass) {
        return stream.filter(rClass::isInstance).map(rClass::cast);
    }

    @NotNull
    public static <K, E> @Unmodifiable Map<K, List<E>> group(@NotNull Stream<E> stream, @NotNull Function<E, K> keyMapper) {
        return Collections.unmodifiableMap(stream.collect(Collectors.groupingBy(keyMapper)));
    }

    @NotNull
    public static <K, V, R> Stream<R> mapIndexed(@NotNull Map<K, V> map, @NotNull IndexedFunction<Map.Entry<K, V>, R> function) {
        return CollectionUtil.mapIndexed(map.entrySet(), function);
    }

    @NotNull
    public static <E, R> Stream<R> mapIndexed(@NotNull Collection<E> collection, @NotNull IndexedFunction<E, R> function) {
        return CollectionUtil.mapIndexed(collection.stream(), function);
    }

    @NotNull
    public static <E, R> Stream<R> mapIndexed(@NotNull Stream<E> stream, @NotNull IndexedFunction<E, R> function) {
        AtomicInteger integer = new AtomicInteger();
        return stream.map(e -> function.apply(integer.getAndIncrement(), e));
    }

    @NotNull
    public static <E, T extends FloatCollection> T mapFloat(@NotNull Stream<E> stream, @NotNull FloatFunction<E> mapper, @NotNull Supplier<T> creator) {
        FloatCollection collect = (FloatCollection)creator.get();
        stream.forEach(e -> collect.add(mapper.apply(e)));
        return (T)collect;
    }

    @NotNull
    public static <K, V, R> @Unmodifiable Map<K, R> mapValue(@NotNull Map<K, V> original, @NotNull Function<V, R> mapper) {
        return CollectionUtil.associate(original.entrySet(), Map.Entry::getKey, (E e) -> mapper.apply(e.getValue()));
    }

    @NotNull
    public static <E, K, V> @Unmodifiable Map<K, V> associate(@NotNull Collection<E> collection, @NotNull Function<E, K> keyMapper, @NotNull Function<E, V> valueMapper) {
        return collection.isEmpty() ? Collections.emptyMap() : CollectionUtil.associate(collection.stream(), keyMapper, valueMapper);
    }

    @NotNull
    public static <T> Predicate<T> filterWithWarning(@NotNull Predicate<T> predicate, @NotNull Function<T, String> lazyLogFunction) {
        BetterModelLogger logger = BetterModel.platform().logger();
        return t -> {
            boolean testedValue = predicate.test(t);
            if (!testedValue) {
                logger.warn(LogUtil.toLog((String)lazyLogFunction.apply(t), (TextColor)NamedTextColor.YELLOW));
            }
            return testedValue;
        };
    }

    @NotNull
    public static <E, K> @Unmodifiable Map<K, E> associate(@NotNull Collection<E> collection, @NotNull Function<E, K> keyMapper) {
        return collection.isEmpty() ? Collections.emptyMap() : CollectionUtil.associate(collection.stream(), keyMapper);
    }

    @NotNull
    public static <E, K> @Unmodifiable Map<K, E> associate(@NotNull Stream<E> stream, @NotNull Function<E, K> keyMapper) {
        return CollectionUtil.associate(stream, keyMapper, (E e) -> e);
    }

    @NotNull
    public static <E, K, V> @Unmodifiable Map<K, V> associate(@NotNull Stream<E> stream, @NotNull Function<E, K> keyMapper, @NotNull Function<E, V> valueMapper) {
        return stream.collect(Collectors.toUnmodifiableMap(keyMapper, valueMapper));
    }

    @FunctionalInterface
    public static interface IndexedFunction<T, R> {
        public R apply(int var1, T var2);
    }

    @FunctionalInterface
    public static interface FloatFunction<T> {
        public float apply(T var1);
    }
}

