/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.nms;

import kr.toxicity.model.api.entity.BaseEntity;
import kr.toxicity.model.api.nms.DisplayTransformer;
import kr.toxicity.model.api.nms.Identifiable;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.platform.PlatformBillboard;
import kr.toxicity.model.api.platform.PlatformItemStack;
import kr.toxicity.model.api.platform.PlatformItemTransform;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.tracker.ModelRotation;
import org.jetbrains.annotations.NotNull;

public interface ModelDisplay
extends Identifiable {
    public boolean invisible();

    public void invisible(boolean var1);

    public void rotate(@NotNull ModelRotation var1, @NotNull PacketBundler var2);

    public void syncEntity(@NotNull BaseEntity var1);

    public void syncPosition(@NotNull PlatformLocation var1);

    public void moveDuration(int var1);

    public void display(@NotNull PlatformItemTransform var1);

    default public void spawn(@NotNull PacketBundler bundler) {
        this.spawn(!this.invisible(), bundler);
    }

    default public void spawnWithEntityData(@NotNull PacketBundler bundler) {
        boolean visible = !this.invisible();
        this.spawn(visible, bundler);
        this.sendEntityData(visible, bundler);
    }

    public void spawn(boolean var1, @NotNull PacketBundler var2);

    public void remove(@NotNull PacketBundler var1);

    public void teleport(@NotNull PlatformLocation var1, @NotNull PacketBundler var2);

    public void item(@NotNull PlatformItemStack var1);

    @NotNull
    public DisplayTransformer createTransformer();

    public void sendDirtyEntityData(@NotNull PacketBundler var1);

    public void sendEntityData(boolean var1, @NotNull PacketBundler var2);

    public void brightness(int var1, int var2);

    public void viewRange(float var1);

    public void shadowRadius(float var1);

    public void sendPosition(@NotNull BaseEntity var1, @NotNull PacketBundler var2);

    public void glow(boolean var1);

    public void glowColor(int var1);

    public void billboard(@NotNull PlatformBillboard var1);
}

