/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@ApiStatus.Internal
public record Float3(float x, float y, float z) {
    public static final Float3 CENTER = new Float3(8.0f, 8.0f, 8.0f);
    public static final Float3 ZERO = new Float3(0.0f, 0.0f, 0.0f);
    public static final JsonDeserializer<Float3> PARSER = (json, typeOfT, context) -> {
        JsonArray array = json.getAsJsonArray();
        return new Float3(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
    };

    public Float3(float value) {
        this(value, value, value);
    }

    @NotNull
    public Float3 plus(@NotNull Float3 other) {
        return new Float3(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public Float3 convertToMinecraftDegree() {
        Vector3f vec = MathUtil.toXYZEuler(this.toVector());
        return new Float3(vec.x, vec.y, vec.z);
    }

    @NotNull
    public Float3 rotate(@NotNull Quaternionf quaternionf) {
        Vector3f vec = this.toVector().rotate((Quaternionfc)quaternionf);
        return new Float3(vec.x, vec.y, vec.z);
    }

    @NotNull
    public Float3 minus(@NotNull Float3 other) {
        return new Float3(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public Float3 toBlockScale() {
        return this.div(16.0f);
    }

    @NotNull
    public Float3 times(float value) {
        return new Float3(this.x * value, this.y * value, this.z * value);
    }

    @NotNull
    public Float3 div(float value) {
        return new Float3(this.x / value, this.y / value, this.z / value);
    }

    @NotNull
    public Float3 invertXZ() {
        return new Float3(-this.x, this.y, -this.z);
    }

    @NotNull
    public JsonArray toJson() {
        JsonArray array = new JsonArray(3);
        array.add((Number)Float.valueOf(this.x));
        array.add((Number)Float.valueOf(this.y));
        array.add((Number)Float.valueOf(this.z));
        return array;
    }

    @NotNull
    public Vector3f toVector() {
        return new Vector3f(this.x, this.y, this.z);
    }

    @Override
    public int hashCode() {
        int hash = 31;
        int value = 1;
        value = value * hash + MathUtil.similarHashCode(this.x);
        value = value * hash + MathUtil.similarHashCode(this.y);
        value = value * hash + MathUtil.similarHashCode(this.z);
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        float x1;
        float f;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Float3)) return false;
        Float3 float3 = (Float3)obj;
        try {
            x1 = f = float3.x();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        float y1 = f = float3.y();
        float z1 = f = float3.z();
        if (!MathUtil.isSimilar(this.x, x1)) return false;
        if (!MathUtil.isSimilar(this.y, y1)) return false;
        if (!MathUtil.isSimilar(this.z, z1)) return false;
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return this.toJson().toString();
    }
}

