/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record IndicatorConfig(@NotNull @Unmodifiable Set<IndicatorOption> options) {
    public static final IndicatorConfig DEFAULT = new IndicatorConfig(Collections.emptySet());

    @NotNull
    public static IndicatorConfig from(@NotNull Predicate<String> predicate) {
        return new IndicatorConfig(Collections.unmodifiableSet(Arrays.stream(IndicatorOption.values()).filter(o -> predicate.test(o.config)).collect(Collectors.toCollection(() -> EnumSet.noneOf(IndicatorOption.class)))));
    }

    public static enum IndicatorOption {
        PROGRESS_BAR("progress_bar");

        private final String config;

        @Generated
        private IndicatorOption(String config) {
            this.config = config;
        }
    }
}

