/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Arrays;
import kr.toxicity.model.api.animation.AnimationProgress;
import kr.toxicity.model.api.animation.TimedStorage;
import kr.toxicity.model.api.bone.BoneMovement;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public record AnimationKeyframe(@NotNull AnimationProgress[] progresses) implements TimedStorage<AnimationProgress>
{
    @NotNull
    public static Builder builder(int size, boolean rotateGlobal) {
        return new Builder(size, rotateGlobal);
    }

    @Override
    @NotNull
    public AnimationProgress get(int i2) {
        return this.progresses[i2];
    }

    @Override
    @NotNull
    public AnimationProgress getLast() {
        return this.get(this.progresses.length - 1);
    }

    @Override
    public int size() {
        return this.progresses.length;
    }

    @NotNull
    public TimedStorage<AnimationProgress> toEmpty() {
        return TimedStorage.listOf(Arrays.stream(this.progresses).map(AnimationProgress::toEmpty).toList());
    }

    public static final class Builder {
        private final AnimationArray set;
        private final AnimationProgress[] progresses;
        private int index = 0;

        private Builder(int size, boolean rotateGlobal) {
            this.set = new AnimationArray(size, rotateGlobal);
            this.progresses = new AnimationProgress[size];
        }

        public void write(float time, @NotNull Vector3f position, @NotNull Vector3f scale2, @NotNull Vector3f rotation2, boolean skipInterpolation) {
            int i2 = this.index++;
            int x = i2 * 3;
            int y = x + 1;
            int z = x + 2;
            this.set.times[i2] = time;
            this.set.position[x] = position.x;
            this.set.position[y] = position.y;
            this.set.position[z] = position.z;
            this.set.scale[x] = scale2.x + 1.0f;
            this.set.scale[y] = scale2.y + 1.0f;
            this.set.scale[z] = scale2.z + 1.0f;
            this.set.rotation[x] = rotation2.x;
            this.set.rotation[y] = rotation2.y;
            this.set.rotation[z] = rotation2.z;
            this.set.skipInterpolation[i2] = skipInterpolation;
            this.progresses[i2] = MathUtil.isNotZero(position) || MathUtil.isNotZero(scale2) || MathUtil.isNotZero(rotation2) ? new ArrayProgress(this.set, i2) : AnimationProgress.empty(time);
        }

        @NotNull
        public AnimationKeyframe build() {
            return new AnimationKeyframe(this.progresses);
        }
    }

    private record ArrayProgress(@NotNull AnimationArray array, int index) implements AnimationProgress
    {
        @Override
        @NotNull
        public BoneMovement animate(@NotNull BoneMovement movement, @NotNull BoneMovement dest) {
            Vector3f destPos = movement.position().get(dest.position());
            Vector3f destScl = movement.scale().get(dest.scale());
            Quaternionf destRot = movement.rotation().get(dest.rotation());
            Vector3f destRawRot = movement.rawRotation().get(dest.rawRotation());
            float[] position = this.array.position;
            float[] scale2 = this.array.scale;
            float[] rotation2 = this.array.rotation;
            int x = this.index * 3;
            int y = x + 1;
            int z = x + 2;
            destPos.add(position[x], position[y], position[z]);
            destScl.mul(scale2[x], scale2[y], scale2[z]);
            MathUtil.toQuaternion(destRawRot.add(rotation2[x], rotation2[y], rotation2[z]), destRot);
            return dest;
        }

        @Override
        public boolean skipInterpolation() {
            return this.array.skipInterpolation[this.index];
        }

        @Override
        public boolean globalRotation() {
            return this.array.rotateGlobal;
        }

        @Override
        public float time() {
            return this.array.times[this.index];
        }
    }

    private record AnimationArray(boolean rotateGlobal, boolean[] skipInterpolation, float[] times, float[] position, float[] scale, float[] rotation) {
        AnimationArray(int size, boolean rotateGlobal) {
            this(rotateGlobal, new boolean[size], new float[size], new float[size * 3], new float[size * 3], new float[size * 3]);
        }
    }
}

