/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import java.util.Iterator;
import kr.toxicity.model.api.animation.Timed;
import kr.toxicity.model.api.animation.TimedStorage;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public sealed interface AnimationIterator<T extends Timed>
extends Iterator<T> {
    public void clear();

    @NotNull
    public Type type();

    public static final class Loop<T extends Timed>
    implements AnimationIterator<T> {
        private final TimedStorage<T> keyframe;
        private int index = 0;

        @Override
        public void clear() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        @NotNull
        public T next() {
            if (this.index >= this.keyframe.size()) {
                this.index = 0;
            }
            return this.keyframe.get(this.index++);
        }

        @Override
        @NotNull
        public Type type() {
            return Type.LOOP;
        }

        @Generated
        private Loop(TimedStorage<T> keyframe) {
            this.keyframe = keyframe;
        }
    }

    public static final class HoldOnLast<T extends Timed>
    implements AnimationIterator<T> {
        private final TimedStorage<T> keyframe;
        private int index = 0;

        @Override
        public void clear() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        @NotNull
        public T next() {
            if (this.index >= this.keyframe.size()) {
                return this.keyframe.getLast();
            }
            return this.keyframe.get(this.index++);
        }

        @Override
        @NotNull
        public Type type() {
            return Type.HOLD_ON_LAST;
        }

        @Generated
        private HoldOnLast(TimedStorage<T> keyframe) {
            this.keyframe = keyframe;
        }
    }

    public static final class PlayOnce<T extends Timed>
    implements AnimationIterator<T> {
        private final TimedStorage<T> keyframe;
        private int index = 0;

        @Override
        public void clear() {
            this.index = Integer.MAX_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keyframe.size();
        }

        @Override
        @NotNull
        public T next() {
            return this.keyframe.get(this.index++);
        }

        @Override
        @NotNull
        public Type type() {
            return Type.PLAY_ONCE;
        }

        @Generated
        private PlayOnce(TimedStorage<T> keyframe) {
            this.keyframe = keyframe;
        }
    }

    public static enum Type {
        PLAY_ONCE{

            @Override
            @NotNull
            public <T extends Timed> AnimationIterator<T> create(@NotNull TimedStorage<T> keyframes) {
                return new PlayOnce<T>(keyframes);
            }
        }
        ,
        LOOP{

            @Override
            @NotNull
            public <T extends Timed> AnimationIterator<T> create(@NotNull TimedStorage<T> keyframes) {
                return new Loop<T>(keyframes);
            }
        }
        ,
        HOLD_ON_LAST{

            @Override
            @NotNull
            public <T extends Timed> AnimationIterator<T> create(@NotNull TimedStorage<T> keyframes) {
                return new HoldOnLast<T>(keyframes);
            }
        };


        @NotNull
        public abstract <T extends Timed> AnimationIterator<T> create(@NotNull TimedStorage<T> var1);

        @Generated
        private Type() {
        }
    }
}

