/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.bukkit.nms.v1_21_R3;

import kr.toxicity.model.api.event.ModelDamageSource;
import kr.toxicity.model.api.platform.PlatformEntity;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.bukkit.nms.v1_21_R3.BukkitWrappersKt;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkr/toxicity/model/bukkit/nms/v1_21_R3/ModelDamageSourceImpl;", "Lkr/toxicity/model/api/event/ModelDamageSource;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "<init>", "(Lnet/minecraft/world/damagesource/DamageSource;)V", "getCausingEntity", "Lkr/toxicity/model/api/platform/PlatformEntity;", "getDirectEntity", "getDamageLocation", "Lkr/toxicity/model/api/platform/PlatformLocation;", "getSourceLocation", "isIndirect", "", "getFoodExhaustion", "", "scalesWithDifficulty", "v1_21_R3"})
public final class ModelDamageSourceImpl
implements ModelDamageSource {
    @NotNull
    private final DamageSource source;

    public ModelDamageSourceImpl(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    @Override
    @Nullable
    public PlatformEntity getCausingEntity() {
        net.minecraft.world.entity.Entity entity = this.source.getEntity();
        return entity != null && (entity = entity.getBukkitEntity()) != null ? BukkitWrappersKt.wrap((Entity)entity) : null;
    }

    @Override
    @Nullable
    public PlatformEntity getDirectEntity() {
        net.minecraft.world.entity.Entity entity = this.source.getDirectEntity();
        return entity != null && (entity = entity.getBukkitEntity()) != null ? BukkitWrappersKt.wrap((Entity)entity) : null;
    }

    @Override
    @Nullable
    public PlatformLocation getDamageLocation() {
        PlatformLocation platformLocation;
        Vec3 vec3 = this.source.sourcePositionRaw();
        if (vec3 != null) {
            Vec3 it = vec3;
            boolean bl = false;
            PlatformEntity platformEntity = this.getCausingEntity();
            Location location = CraftLocation.toBukkit((Vec3)it, platformEntity != null && (platformEntity = BukkitWrappersKt.unwarp(platformEntity)) != null ? platformEntity.getWorld() : null);
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toBukkit(...)");
            platformLocation = BukkitWrappersKt.wrap(location);
        } else {
            platformLocation = null;
        }
        return platformLocation;
    }

    @Override
    @Nullable
    public PlatformLocation getSourceLocation() {
        PlatformLocation platformLocation;
        Vec3 vec3 = this.source.getSourcePosition();
        if (vec3 != null) {
            Vec3 it = vec3;
            boolean bl = false;
            PlatformEntity platformEntity = this.getCausingEntity();
            Location location = CraftLocation.toBukkit((Vec3)it, platformEntity != null && (platformEntity = BukkitWrappersKt.unwarp(platformEntity)) != null ? platformEntity.getWorld() : null);
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"toBukkit(...)");
            platformLocation = BukkitWrappersKt.wrap(location);
        } else {
            platformLocation = null;
        }
        return platformLocation;
    }

    @Override
    public boolean isIndirect() {
        return !this.source.isDirect();
    }

    @Override
    public float getFoodExhaustion() {
        return this.source.getFoodExhaustion();
    }

    @Override
    public boolean scalesWithDifficulty() {
        return this.source.scalesWithDifficulty();
    }
}

