/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.platform;

import java.util.Optional;
import java.util.UUID;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.platform.PlatformLocation;
import kr.toxicity.model.api.platform.PlatformRegionHolder;
import kr.toxicity.model.api.scheduler.ModelTask;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.EntityTrackerRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformEntity
extends PlatformRegionHolder {
    @NotNull
    public UUID uuid();

    @NotNull
    public PlatformLocation location();

    @Override
    @Nullable
    default public ModelTask task(@NotNull Runnable runnable) {
        return this.location().task(runnable);
    }

    @Override
    @Nullable
    default public ModelTask taskLater(long delay, @NotNull Runnable runnable) {
        return this.location().taskLater(delay, runnable);
    }

    @NotNull
    default public Optional<EntityTrackerRegistry> registry() {
        return BetterModel.registry(this.uuid());
    }

    @NotNull
    default public Optional<EntityTracker> tracker(@NotNull String name) {
        return this.registry().map(registry -> registry.tracker(name));
    }
}

