/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public record DebugConfig(@NotNull @Unmodifiable Set<DebugOption> options) {
    public static final DebugConfig DEFAULT = new DebugConfig(Collections.emptySet());

    public boolean has(@NotNull DebugOption option) {
        return this.options.contains((Object)option);
    }

    @NotNull
    public static DebugConfig from(@NotNull Predicate<String> predicate) {
        return new DebugConfig(Collections.unmodifiableSet(Arrays.stream(DebugOption.values()).filter(o -> predicate.test(o.config)).collect(Collectors.toCollection(() -> EnumSet.noneOf(DebugOption.class)))));
    }

    public static enum DebugOption {
        EXCEPTION("exception"),
        HITBOX("hitbox"),
        PACK("pack"),
        TRACKER("tracker");

        private final String config;

        @Generated
        private DebugOption(String config) {
            this.config = config;
        }
    }
}

