/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api;

import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.InputStream;
import java.util.function.Consumer;
import kr.toxicity.model.api.BetterModelConfig;
import kr.toxicity.model.api.BetterModelEvaluator;
import kr.toxicity.model.api.BetterModelEventBus;
import kr.toxicity.model.api.BetterModelLogger;
import kr.toxicity.model.api.event.ModelEventApplication;
import kr.toxicity.model.api.manager.ModelManager;
import kr.toxicity.model.api.manager.PlayerManager;
import kr.toxicity.model.api.manager.ProfileManager;
import kr.toxicity.model.api.manager.ReloadInfo;
import kr.toxicity.model.api.manager.ScriptManager;
import kr.toxicity.model.api.manager.SkinManager;
import kr.toxicity.model.api.nms.NMS;
import kr.toxicity.model.api.pack.PackResult;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.api.platform.PlatformAdapter;
import kr.toxicity.model.api.scheduler.ModelScheduler;
import kr.toxicity.model.api.version.MinecraftVersion;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BetterModelPlatform
extends ModelEventApplication {
    @NotNull
    public File dataFolder();

    @NotNull
    public JarType jarType();

    @NotNull
    default public ReloadResult reload() {
        return this.reload(ReloadInfo.DEFAULT);
    }

    @NotNull
    default public ReloadResult reload(@NotNull Audience sender) {
        return this.reload(ReloadInfo.builder().sender(sender).build());
    }

    @NotNull
    public ReloadResult reload(@NotNull ReloadInfo var1);

    public boolean isSnapshot();

    @NotNull
    public BetterModelConfig config();

    @NotNull
    public MinecraftVersion version();

    @NotNull
    public Semver semver();

    @NotNull
    public NMS nms();

    @NotNull
    public ModelManager modelManager();

    @NotNull
    public PlayerManager playerManager();

    @NotNull
    public ScriptManager scriptManager();

    @NotNull
    public SkinManager skinManager();

    @NotNull
    public ProfileManager profileManager();

    @NotNull
    public ModelScheduler scheduler();

    @NotNull
    public PlatformAdapter adapter();

    public void addReloadStartHandler(@NotNull Consumer<PackZipper> var1);

    public void addReloadEndHandler(@NotNull Consumer<ReloadResult> var1);

    @NotNull
    public BetterModelLogger logger();

    @NotNull
    public BetterModelEvaluator evaluator();

    @NotNull
    public BetterModelEventBus eventBus();

    @Nullable
    public InputStream getResource(@NotNull String var1);

    public static sealed interface ReloadResult {

        public record Failure(@NotNull Throwable throwable) implements ReloadResult
        {
        }

        public static enum OnReload implements ReloadResult
        {
            INSTANCE;

        }

        public record Success(boolean firstLoad, long assetsTime, @NotNull PackResult packResult) implements ReloadResult
        {
            public long packingTime() {
                return this.packResult().time();
            }

            public long totalTime() {
                return this.assetsTime + this.packingTime();
            }

            public long length() {
                File dir = this.packResult.directory();
                return dir != null && dir.isFile() ? dir.length() : this.packResult.stream().mapToLong(b -> b.bytes().length).sum();
            }
        }
    }

    public static enum JarType {
        SPIGOT("spigot"),
        PAPER("paper"),
        FABRIC("fabric");

        private final String raw;

        public String raw() {
            return this.raw;
        }

        @Generated
        private JarType(String raw) {
            this.raw = raw;
        }
    }
}

