/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kr.toxicity.model.api.data.raw.ModelData;
import kr.toxicity.model.api.data.raw.ModelLoadResult;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public record ModelAsset(@NotNull String rawName, @NotNull String name, long sizeAssume, @NotNull StreamSupplier supplier) implements Comparable<ModelAsset>
{
    @NotNull
    public static ModelAsset of(@NotNull String name, byte[] bytes) {
        return ModelAsset.of(name, bytes.length, () -> new ByteArrayInputStream(bytes));
    }

    @NotNull
    public static ModelAsset of(@NotNull String name, @NotNull StreamSupplier supplier) {
        return ModelAsset.of(name, 0L, supplier);
    }

    @NotNull
    public static ModelAsset of(@NotNull String name, long sizeAssume, @NotNull StreamSupplier supplier) {
        PackUtil.assertPackName(name);
        return new ModelAsset(name, name, sizeAssume, supplier);
    }

    @NotNull
    public static ModelAsset of(@NotNull File file) {
        return new ModelAsset(file.getPath(), ModelAsset.nameWithoutExtension(file.getName()), file.length(), () -> new FileInputStream(file));
    }

    @NotNull
    public static ModelAsset of(@NotNull Path path) {
        try {
            return new ModelAsset(path.toString(), ModelAsset.nameWithoutExtension(path.getFileName().toString()), Files.size(path), () -> Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String nameWithoutExtension(@NotNull String name) {
        int index = name.lastIndexOf(46);
        return PackUtil.toPackName(index > 0 ? name.substring(0, index) : name);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ModelLoadResult toResult() {
        try (InputStream stream = this.supplier.get();){
            ModelLoadResult modelLoadResult;
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                ModelData result = (ModelData)ModelData.GSON.fromJson((Reader)reader, ModelData.class);
                result.assertSupported();
                modelLoadResult = result.loadBlueprint(this.name);
            }
            return modelLoadResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(@NonNull ModelAsset o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ModelAsset)) {
            return false;
        }
        ModelAsset that = (ModelAsset)o;
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public @NonNull String toString() {
        return this.rawName;
    }

    public static interface StreamSupplier {
        @NotNull
        public InputStream get() throws IOException;
    }
}

