/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.pack.PackNamespace;
import kr.toxicity.model.api.pack.PackOverlay;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import org.jetbrains.annotations.NotNull;

public final class PackAssets {
    final PackPath path;
    final PackOverlay overlay;
    final Map<PackPath, PackResource> resourceMap = new ConcurrentHashMap<PackPath, PackResource>();
    private final PackNamespace bettermodel;
    private final PackNamespace minecraft;

    PackAssets(@NotNull PackOverlay overlay) {
        this.overlay = overlay;
        this.path = overlay.path(BetterModel.config().namespace());
        this.bettermodel = new PackNamespace(this, BetterModel.config().namespace());
        this.minecraft = new PackNamespace(this, "minecraft");
    }

    @NotNull
    public PackNamespace bettermodel() {
        return this.bettermodel;
    }

    @NotNull
    public PackNamespace minecraft() {
        return this.minecraft;
    }

    int size() {
        return this.resourceMap.size();
    }

    boolean dirty() {
        return this.size() > 0;
    }

    public void add(@NotNull String path, long size, @NotNull Supplier<byte[]> supplier) {
        this.add(new String[]{path}, size, supplier);
    }

    public void add(@NotNull String[] paths, long size, @NotNull Supplier<byte[]> supplier) {
        PackPath resolve = this.path.resolve(paths);
        this.resourceMap.putIfAbsent(resolve, PackResource.of(this.overlay, resolve, size, supplier));
    }

    public void add(@NotNull String path, @NotNull Supplier<byte[]> supplier) {
        this.add(path, -1L, supplier);
    }

    public void add(@NotNull String[] paths, @NotNull Supplier<byte[]> supplier) {
        this.add(paths, -1L, supplier);
    }
}

