/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.bukkit.platform;

import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.bukkit.platform.BukkitAdapter;
import kr.toxicity.model.api.platform.PlatformItemStack;
import kr.toxicity.model.api.platform.PlatformNamespace;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BukkitItemStack(@NotNull ItemStack source) implements PlatformItemStack
{
    @Override
    public boolean isAir() {
        return this.source.getType().isAir() || this.source.getAmount() <= 0;
    }

    @Override
    @NotNull
    public PlatformItemStack enchant(boolean enchant) {
        ItemMeta meta = this.source.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setEnchantmentGlintOverride(Boolean.valueOf(enchant));
        this.source.setItemMeta(meta);
        return this;
    }

    @Override
    @NotNull
    public PlatformItemStack modelData(int customModelData, @Nullable PlatformNamespace namespace) {
        ItemMeta meta = this.source.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setCustomModelData(Integer.valueOf(customModelData));
        if (BetterModel.platform().version().useItemModelName()) {
            meta.setItemModel(namespace == null ? null : new NamespacedKey(namespace.namespace(), namespace.path()));
        }
        this.source.setItemMeta(meta);
        return this;
    }

    @Override
    @NotNull
    public PlatformItemStack clone() {
        return BukkitAdapter.adapt(this.source.clone());
    }
}

