/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.library.dynamicuv;

import kr.toxicity.library.dynamicuv.ElementVector;
import kr.toxicity.library.dynamicuv.UVSpace;
import org.jetbrains.annotations.NotNull;

public enum UVAxis {
    XZ{

        @Override
        public void iterate(@NotNull ElementVector from, @NotNull UVSpace space, @NotNull ElementVector div, LineConsumer consumer) {
            float xi = from.x();
            for (int x = 0; x < space.x(); ++x) {
                float zi = from.z();
                for (int z = 0; z < space.z(); ++z) {
                    consumer.consume(xi, zi);
                    zi += div.z();
                }
                xi += div.x();
            }
        }
    }
    ,
    XY{

        @Override
        public void iterate(@NotNull ElementVector from, @NotNull UVSpace space, @NotNull ElementVector div, LineConsumer consumer) {
            float xi = from.x();
            for (int x = 0; x < space.x(); ++x) {
                float yi = from.y();
                for (int y = 0; y < space.y(); ++y) {
                    consumer.consume(xi, yi);
                    yi += div.y();
                }
                xi += div.x();
            }
        }
    }
    ,
    ZY{

        @Override
        public void iterate(@NotNull ElementVector from, @NotNull UVSpace space, @NotNull ElementVector div, LineConsumer consumer) {
            float zi = from.z();
            for (int z = 0; z < space.z(); ++z) {
                float yi = from.y();
                for (int y = 0; y < space.y(); ++y) {
                    consumer.consume(zi, yi);
                    yi += div.y();
                }
                zi += div.z();
            }
        }
    };


    public abstract void iterate(@NotNull ElementVector var1, @NotNull UVSpace var2, @NotNull ElementVector var3, LineConsumer var4);

    public static interface LineConsumer {
        public void consume(float var1, float var2);
    }
}

