/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.config.DebugConfig;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class LogUtil {
    private LogUtil() {
        throw new RuntimeException();
    }

    public static void handleException(@NotNull String message, @NotNull Throwable throwable) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(Component.text((String)message));
        list.add(LogUtil.toLog("Reason: " + throwable.getMessage(), (TextColor)NamedTextColor.YELLOW));
        if (BetterModel.config().debug().has(DebugConfig.DebugOption.EXCEPTION)) {
            list.add(LogUtil.toLog("Stack trace:", (TextColor)NamedTextColor.RED));
            try (ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                 PrintStream print = new PrintStream(byteArray);){
                throwable.printStackTrace(print);
                list.add(LogUtil.toLog(byteArray.toString(StandardCharsets.UTF_8), (TextColor)NamedTextColor.RED));
            }
            catch (IOException e) {
                list.add(LogUtil.toLog("Unknown", (TextColor)NamedTextColor.RED));
            }
        } else {
            list.add(LogUtil.toLog("If you want to see the stack trace, set debug.exception to true in config.yml", (TextColor)NamedTextColor.LIGHT_PURPLE));
        }
        BetterModel.platform().logger().warn((Component[])list.toArray(Component[]::new));
    }

    @NotNull
    public static Component toLog(@NotNull String message, @NotNull TextColor color) {
        return ((TextComponent.Builder)Component.text().content(message).color(color)).build();
    }

    public static void debug(@NotNull DebugConfig.DebugOption option, @NotNull Supplier<String> log) {
        LogUtil.debug(option, () -> BetterModel.platform().logger().info(new Component[]{((TextComponent.Builder)((TextComponent.Builder)Component.text().append(LogUtil.toLog("[DEBUG-" + String.valueOf((Object)option) + "] ", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)((String)log.get())))).build()}));
    }

    public static void debug(@NotNull DebugConfig.DebugOption option, @NotNull Runnable runnable) {
        if (BetterModel.config().debug().has(option)) {
            runnable.run();
        }
    }
}

