/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.mount;

import kr.toxicity.model.api.platform.PlatformLivingEntity;
import kr.toxicity.model.api.platform.PlatformPlayer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public interface MountController {
    @NotNull
    public Vector3f move(@NotNull PlatformPlayer var1, @NotNull PlatformLivingEntity var2, @NotNull Vector3f var3, @NotNull Vector3f var4);

    @NotNull
    default public Vector3f moveOnFly(@NotNull PlatformPlayer player, @NotNull PlatformLivingEntity entity, @NotNull Vector3f input, @NotNull Vector3f travelVector) {
        return this.move(player, entity, input, travelVector).mul(1.5f);
    }

    default public Vector3f move(@NotNull MoveType type, @NotNull PlatformPlayer player, @NotNull PlatformLivingEntity entity, @NotNull Vector3f input, @NotNull Vector3f travelVector) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.move(player, entity, input, travelVector);
            case 1 -> this.moveOnFly(player, entity, input, travelVector);
        };
    }

    default public boolean canMount() {
        return true;
    }

    default public boolean canDismountBySelf() {
        return true;
    }

    default public boolean canControl() {
        return true;
    }

    default public boolean canJump() {
        return true;
    }

    default public boolean canFly() {
        return false;
    }

    default public boolean canBeDamagedByRider() {
        return false;
    }

    @NotNull
    default public Modifier modifier() {
        return new Modifier(this);
    }

    public static enum MoveType {
        DEFAULT,
        FLY;

    }

    public static class Modifier {
        private final MountController source;
        private boolean canMount;
        private boolean canDismountBySelf;
        private boolean canControl;
        private boolean canJump;
        private boolean canFly;
        private boolean canBeDamagedByRider;

        private Modifier(@NotNull MountController controller) {
            this.source = controller;
            this.canMount = controller.canMount();
            this.canDismountBySelf = controller.canDismountBySelf();
            this.canControl = controller.canControl();
            this.canJump = controller.canJump();
            this.canFly = controller.canFly();
        }

        @NotNull
        public Modifier canDismountBySelf(boolean canDismountBySelf) {
            this.canDismountBySelf = canDismountBySelf;
            return this;
        }

        @NotNull
        public Modifier canMount(boolean canMount) {
            this.canMount = canMount;
            return this;
        }

        @NotNull
        public Modifier canControl(boolean canControl) {
            this.canControl = canControl;
            return this;
        }

        @NotNull
        public Modifier canFly(boolean canFly) {
            this.canFly = canFly;
            return this;
        }

        @NotNull
        public Modifier canJump(boolean canJump) {
            this.canJump = canJump;
            return this;
        }

        @NotNull
        public Modifier canBeDamagedByRider(boolean canBeDamagedByRider) {
            this.canBeDamagedByRider = canBeDamagedByRider;
            return this;
        }

        @NotNull
        public MountController build() {
            return new MountController(){

                @Override
                @NotNull
                public Vector3f move(@NotNull PlatformPlayer player, @NotNull PlatformLivingEntity entity, @NotNull Vector3f input, @NotNull Vector3f travelVector) {
                    return source.move(player, entity, input, travelVector);
                }

                @Override
                public boolean canDismountBySelf() {
                    return canDismountBySelf;
                }

                @Override
                public boolean canControl() {
                    return canControl;
                }

                @Override
                public boolean canFly() {
                    return canFly;
                }

                @Override
                public boolean canJump() {
                    return canJump;
                }

                @Override
                public boolean canMount() {
                    return canMount;
                }

                @Override
                public boolean canBeDamagedByRider() {
                    return canBeDamagedByRider;
                }
            };
        }
    }
}

